/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.item;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.content.colormap.Colormap;
import net.mehvahdjukaar.polytone.content.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.content.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.content.item.ItemModifier;
import net.mehvahdjukaar.polytone.misc.Parsed;
import net.mehvahdjukaar.polytone.misc.reloader.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.misc.struc.ArrayImage;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class ItemModifiersManager
extends JsonImgPartialReloader {
    private final Map<class_1792, ItemModifier> modifiers = new HashMap<class_1792, ItemModifier>();
    private final Map<class_1792, ItemModifier> vanillaProperties = new HashMap<class_1792, ItemModifier>();

    public ItemModifiersManager() {
        super("item_modifiers", "item_properties");
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        Parsed.SortedMap<ItemModifier> parsedModifiers = Parsed.batchParseAlways(jsons, ItemModifier.CODEC, ops, "item modifier");
        for (Map.Entry<class_2960, Parsed<ItemModifier>> entry : parsedModifiers.entrySet()) {
            class_2960 tintId = entry.getKey();
            Parsed<ItemModifier> result = entry.getValue();
            ItemModifier modifier = result.getResultOrPartial();
            class_2960 barId = tintId.method_48331("_bar");
            if (!modifier.hasBarColor() && textures.containsKey(barId)) {
                modifier = modifier.merge(ItemModifier.ofBarColor(Colormap.createDamage()));
            }
            ColormapsManager.tryAcceptingTexture(textures, barId, modifier.getBarColor(), usedTextures, true);
            if (!result.isEnabled()) continue;
            this.addModifier(tintId, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<class_2960, Object> entry : textures.entrySet()) {
            class_2960 id = entry.getKey();
            Colormap defaultColormap = Colormap.createDamage();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ItemModifier.ofBarColor(defaultColormap));
        }
    }

    private void addModifier(class_2960 id, ItemModifier mod) {
        for (class_6880 holder : mod.targets().compute(id, class_7923.field_41178)) {
            class_1792 i = (class_1792)holder.comp_349();
            this.modifiers.merge(i, mod, ItemModifier::merge);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<class_1792, ItemModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
            ((IPolytoneItem)e.getKey()).polytone$setModifier(null);
        }
        this.modifiers.clear();
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
        for (Map.Entry<class_1792, ItemModifier> e : this.modifiers.entrySet()) {
            class_1792 target = e.getKey();
            ItemModifier modifier = e.getValue();
            this.vanillaProperties.put(target, modifier.apply(target));
            if (!modifier.shouldAttachToItem()) continue;
            ((IPolytoneItem)e.getKey()).polytone$setModifier(modifier);
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Item Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }
}

