/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.content.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.content.colormap.Colormap;
import net.mehvahdjukaar.polytone.content.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.content.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.content.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.content.particle.ParticleInitializer;
import net.mehvahdjukaar.polytone.misc.ColorUtils;
import net.mehvahdjukaar.polytone.misc.codec.CodecUtils;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SemiCustomParticleType
implements CustomParticleFactory {
    private final Optional<class_2396<?>> copyType;
    private class_707<?> copyProvider = null;
    private boolean hasBeenInit = false;
    private class_4002 spriteSet = null;
    @Nullable
    private final ParticleInitializer initializer;
    private final boolean hasPhysics;
    @Nullable
    private final IColorGetter colormap;
    public static final Codec<SemiCustomParticleType> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecUtils.forwardAwareByNameCodec(class_7923.field_41180).fieldOf("copy_from").forGetter(c -> c.copyType), (App)ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), (App)Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), (App)Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap))).apply((Applicative)i, SemiCustomParticleType::new));

    public SemiCustomParticleType(Optional<class_2396<?>> type, Optional<ParticleInitializer> initializer, boolean hasPhysics, Optional<IColorGetter> colorGetter) {
        this.copyType = type;
        this.hasPhysics = hasPhysics;
        this.colormap = colorGetter.orElse(null);
        this.initializer = initializer.orElse(null);
    }

    @Override
    public boolean forceSpawns() {
        return this.copyType.get().method_10299();
    }

    @Override
    public void setSpriteSet(class_4002 spriteSet) {
        this.spriteSet = spriteSet;
    }

    @Override
    @Nullable
    public class_703 createParticleWithState(ExtraDataParticleOptions opt, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state, class_5819 random) {
        try {
            if (this.copyType.isEmpty()) {
                return null;
            }
            if (!this.hasBeenInit) {
                this.init();
            }
            if (this.copyProvider != null) {
                class_3940 sqp;
                class_703 particle = this.copyProvider.method_3090((class_2394)this.copyType.get(), level, x, y, z, xSpeed, ySpeed, zSpeed, random);
                class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                if (this.initializer != null && particle instanceof class_3940) {
                    sqp = (class_3940)particle;
                    this.initializer.initialize(sqp, level, state, pos);
                    opt.apply(sqp);
                }
                if (particle != null) {
                    particle.field_3862 = this.hasPhysics;
                    if (this.colormap != null && particle instanceof class_3940) {
                        sqp = (class_3940)particle;
                        float[] unpack = ColorUtils.unpack(this.colormap.getColor(state, (class_1920)level, pos, 0));
                        sqp.method_74305(unpack[0], unpack[1], unpack[2]);
                    }
                    if (this.hasPhysics) {
                        for (class_265 voxelShape : level.method_20812(null, particle.method_3064())) {
                            if (voxelShape.method_1110()) continue;
                            return null;
                        }
                    }
                }
                return particle;
            }
        }
        catch (Exception e) {
            Polytone.LOGGER.error("Failed to create semi custom particle of type {}. This likely means the particle itself is invalid and not supported. The resource pack that adds it HAS TO change it.", this.copyType, (Object)e);
        }
        return null;
    }

    private void init() {
        this.hasBeenInit = true;
        this.copyProvider = PlatStuff.getParticleProvider(this.copyType.get());
        if (this.copyProvider != null) {
            try {
                this.copyProvider = SemiCustomParticleType.cloneProvider(this.copyProvider, this.spriteSet);
            }
            catch (Exception e) {
                Polytone.LOGGER.error("Failed to clone particle provider. Not supported. Try using a different particle type", (Throwable)e);
            }
        } else {
            Polytone.LOGGER.error("Failed to find particle provider for particle type {}", this.copyType);
        }
    }

    private static <T> T cloneProvider(T original, Object arg) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> clazz = original.getClass();
        Constructor<?> constructor = null;
        for (Constructor<?> cons : clazz.getDeclaredConstructors()) {
            if (cons.getParameterCount() == 0) {
                constructor = cons;
                break;
            }
            if (cons.getParameterCount() != 1 || !cons.getParameterTypes()[0].isInstance(arg)) continue;
            constructor = cons;
            break;
        }
        if (constructor == null) {
            throw new IllegalArgumentException("No suitable constructor found.");
        }
        constructor.setAccessible(true);
        return (T)(constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(arg));
    }
}

