/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.misc.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.misc.codec.AlternativeMapCodec;
import net.mehvahdjukaar.polytone.misc.codec.ForwardAwareByNameCodec;
import net.mehvahdjukaar.polytone.misc.codec.ForwardAwareRegistryFixedCodec;
import net.mehvahdjukaar.polytone.misc.codec.LenientCodecWithLog;
import net.mehvahdjukaar.polytone.misc.codec.LenientHolderSetCodec;
import net.mehvahdjukaar.polytone.misc.codec.LenientUnboundedMapCodec;
import net.mehvahdjukaar.polytone.misc.codec.ReferenceOrDirectCodec;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CodecUtils {
    public static final Codec<class_1799> ITEM_OR_STACK = Codec.withAlternative((Codec)class_1799.field_49747, (Codec)class_7923.field_41178.method_39673(), class_1792::method_7854);
    public static final Codec<List<class_1799>> ITEMSTACK_OR_ITEMSTACK_LIST = Codec.withAlternative((Codec)ITEM_OR_STACK.listOf(), ITEM_OR_STACK, List::of);
    public static final Codec<Supplier<List<class_1799>>> ITEMSTACK_HOLDER_SET = class_6895.method_40340((class_5321)class_7924.field_41197).xmap(l -> () -> l.method_40239().map(class_6880::comp_349).map(class_1799::new).toList(), s -> class_6885.method_40242(((List)s.get()).stream().map(class_1799::method_41409).toList()));
    public static final Codec<Supplier<List<class_1799>>> ITEMSTACK_OR_LIST_OR_HOLDER_SET = Codec.withAlternative((Codec)ITEMSTACK_OR_ITEMSTACK_LIST.xmap(l -> () -> l, Supplier::get), ITEMSTACK_HOLDER_SET);

    public static <E> Codec<class_6885<E>> forwardAwareHomogeneousList(class_5321<? extends class_2378<E>> registryKey) {
        return LenientHolderSetCodec.create(registryKey, new ForwardAwareRegistryFixedCodec(registryKey), false);
    }

    public static <E> Codec<E> forwardAwareByNameCodec(class_2378<E> reg, E defaultValue) {
        return new ForwardAwareByNameCodec(reg.method_39673()).xmap(a -> a.orElse(defaultValue), Optional::of);
    }

    public static <E> Codec<Optional<E>> forwardAwareByNameCodec(class_2378<E> reg) {
        return new ForwardAwareByNameCodec(reg.method_39673());
    }

    public static <E> Codec<Optional<class_6880<E>>> forwardAwareHolderByNameCodec(class_2378<E> reg) {
        return new ForwardAwareByNameCodec<class_6880<E>>(reg.method_40294());
    }

    public static <E> Codec<class_6880<E>> forwardAwareHolderByNameCodec(class_2378<E> reg, Supplier<class_6880<E>> defaultValue) {
        return new ForwardAwareByNameCodec(reg.method_40294()).xmap(a -> (class_6880)a.orElseGet(defaultValue), Optional::of);
    }

    public static Codec<class_3414> forwardAwareSoundEvent() {
        return CodecUtils.forwardAwareByNameCodec(class_7923.field_41172, class_3417.field_42593);
    }

    public static Codec<class_6880<class_3414>> forwardAwareSoundEventHolder() {
        return CodecUtils.forwardAwareHolderByNameCodec(class_7923.field_41172, () -> class_7923.field_41172.method_47983((Object)class_3417.field_42593));
    }

    public static <A, B> LenientUnboundedMapCodec<A, B> lenientUnboundedMap(Codec<A> keyCodec, Codec<B> elementCodec) {
        return new LenientUnboundedMapCodec<A, B>(keyCodec, elementCodec);
    }

    public static <A> MapCodec<A> lenientWithLog(Codec<A> elementCodec, String name, A defaultValue) {
        return LenientCodecWithLog.of(elementCodec, name, defaultValue);
    }

    public static <A> MapCodec<Optional<A>> lenientWithLog(Codec<A> elementCodec, String name) {
        return LenientCodecWithLog.of(elementCodec, name);
    }

    public static <B> MapCodec<Optional<B>> optionalAlias(Codec<B> codec, String primaryName, String alias) {
        return AlternativeMapCodec.optionalAlias(codec, primaryName, alias);
    }

    public static <B> MapCodec<B> alias(Codec<B> codec, String primaryName, String alias) {
        return AlternativeMapCodec.alias(codec, primaryName, alias);
    }

    public static <E> ReferenceOrDirectCodec<E> referenceOrDirect(Codec<? extends E> reference, Codec<? extends E> direct) {
        return new ReferenceOrDirectCodec<E>(reference, direct);
    }

    public static <E> ReferenceOrDirectCodec<E> referenceOrDirect(Codec<? extends E> reference, Codec<? extends E> direct, boolean bothStrings) {
        return new ReferenceOrDirectCodec<E>(reference, direct, bothStrings);
    }

    @SafeVarargs
    public static <A> Codec<A> withAlternatives(Codec<A> primary, Codec<? extends A> ... secondary) {
        Codec codec = primary;
        for (Codec<? extends A> c : secondary) {
            codec = Codec.withAlternative(codec, c);
        }
        return codec;
    }
}

