/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.misc.exp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.polytone.misc.exp.ConcurrentExpression;
import net.mehvahdjukaar.polytone.misc.exp.ExpressionDelegate;
import net.mehvahdjukaar.polytone.misc.exp.ExpressionUtils;
import net.mehvahdjukaar.polytone.misc.exp.IExpression;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public abstract class PolytoneExpression {
    protected static final String TIME = "TIME";
    protected static final String DAY_TIME = "DAY_TIME";
    protected static final String SUN_TIME = "SUN_TIME";
    protected static final String RAIN = "RAIN";
    protected static final String SEASON = "SEASON";
    protected static final String POS_X = "POS_X";
    protected static final String POS_Y = "POS_Y";
    protected static final String POS_Z = "POS_Z";
    protected static final String SKY_LIGHT = "SKY_LIGHT";
    protected static final String BLOCK_LIGHT = "BLOCK_LIGHT";
    protected static final String TEMPERATURE = "TEMPERATURE";
    protected static final String DOWNFALL = "DOWNFALL";
    protected static final String PLAYER_X = "PLAYER_X";
    protected static final String PLAYER_Y = "PLAYER_Y";
    protected static final String PLAYER_Z = "PLAYER_Z";
    protected static final String DISTANCE_SQUARED = "DISTANCE_SQUARED";
    protected static final String PLAYER_SPEED_SQUARED = "PLAYER_SPEED_SQUARED";
    protected static final String RENDER_DISTANCE = "RENDER_DISTANCE";
    protected static final String DIFFICULTY = "DIFFICULTY";
    protected static final String STATE_FUNC = "state_prop";
    protected static final Function STATE_PROP = new Function("state_prop", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return (float)values.indexOf(blockState.method_11654(p)) / ((float)values.size() - 1.0f);
        }
    };
    protected static final Function STATE_PROP_INT = new Function("state_prop_i", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return values.indexOf(blockState.method_11654(p));
        }
    };
    protected static final ThreadLocal<class_2680> STATE_HACK = new ThreadLocal();
    private final String unparsed;
    protected final IExpression expression;
    protected final boolean hasPos;
    protected final boolean hasTime;
    protected final boolean hasDayTime;
    protected final boolean hasSunTime;
    protected final boolean hasRain;
    protected final boolean hasSeason;
    protected final boolean hasSkyLight;
    protected final boolean hasBlockLight;
    protected final boolean hasTemperature;
    protected final boolean hasDownfall;
    protected final boolean hasPlayer;
    protected final boolean hasDistance;
    protected final boolean hasPlayerSpeed;
    protected final boolean hasRenderDistance;

    public PolytoneExpression(String unparsed) {
        this(unparsed, false);
    }

    public PolytoneExpression(String unparsed, boolean concurrent) {
        FunBuilder funBuilder = new FunBuilder();
        this.buildFunctions(funBuilder);
        VarBuilder varBuilder = new VarBuilder();
        this.buildVars(varBuilder);
        Expression exp = new ExpressionBuilder(unparsed).functions(ExpressionUtils.defFunc(funBuilder.list.toArray(new Function[0]))).variables(varBuilder.list).operator(ExpressionUtils.defOp(new Operator[0])).build();
        this.expression = concurrent ? new ConcurrentExpression(exp) : new ExpressionDelegate(exp);
        this.unparsed = unparsed;
        this.hasPos = unparsed.contains(POS_X) || unparsed.contains(POS_Y) || unparsed.contains(POS_Z);
        this.hasTime = unparsed.contains(TIME);
        this.hasDayTime = unparsed.contains(DAY_TIME);
        this.hasSunTime = unparsed.contains(SUN_TIME);
        this.hasRain = unparsed.contains(RAIN);
        this.hasSeason = unparsed.contains(SEASON);
        this.hasSkyLight = unparsed.contains(SKY_LIGHT);
        this.hasBlockLight = unparsed.contains(BLOCK_LIGHT);
        this.hasTemperature = unparsed.contains(TEMPERATURE);
        this.hasDownfall = unparsed.contains(DOWNFALL);
        this.hasDistance = unparsed.contains(DISTANCE_SQUARED);
        this.hasPlayer = unparsed.contains(PLAYER_X) || unparsed.contains(PLAYER_Y) || unparsed.contains(PLAYER_Z);
        this.hasPlayerSpeed = unparsed.contains(PLAYER_SPEED_SQUARED);
        this.hasRenderDistance = unparsed.contains(RENDER_DISTANCE);
    }

    protected abstract PolytoneExpression createConcurrent();

    protected void buildVars(VarBuilder builder) {
        builder.addAll(POS_X, POS_Y, POS_Z, RAIN, DAY_TIME, SUN_TIME, TIME, SEASON, TEMPERATURE, DOWNFALL, BLOCK_LIGHT, SKY_LIGHT, DISTANCE_SQUARED, PLAYER_X, PLAYER_Y, PLAYER_Z, PLAYER_SPEED_SQUARED, RENDER_DISTANCE);
    }

    protected void buildFunctions(FunBuilder builder) {
    }

    protected String getUnparsed() {
        return this.unparsed;
    }

    protected record FunBuilder(List<Function> list) {
        public FunBuilder() {
            this(new ArrayList<Function>());
        }

        public void add(Function f) {
            this.list.add(f);
        }

        public void addAll(Function ... f) {
            Collections.addAll(this.list, f);
        }

        public Function[] unwrap() {
            return this.list.toArray(new Function[0]);
        }
    }

    protected record VarBuilder(Set<String> list) {
        public VarBuilder() {
            this(new HashSet<String>());
        }

        public void add(String s) {
            this.list.add(s);
        }

        public void addAll(String ... s) {
            Collections.addAll(this.list, s);
        }
    }
}

