/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.misc.render.fabric;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.polytone.misc.render.BakedQuadBuilder;
import net.mehvahdjukaar.polytone.misc.render.BakedQuadsTransformer;
import net.mehvahdjukaar.polytone.misc.render.fabric.BakedQuadBuilderImpl;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_777;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BakedQuadsTransformerImpl
implements BakedQuadsTransformer {
    private Consumer<class_777> inner = i -> {};
    private Boolean shade = null;
    private Integer emissivity = null;
    private Integer tintIndex = null;
    private UnaryOperator<class_2350> directionRemap = UnaryOperator.identity();
    private class_1058 sprite = null;
    private class_1058 lastSpriteHack = null;
    private static final int POSITION = 0;
    private static final int COLOR = 3;
    private static final int UV0 = 4;
    private static final int UV2 = 6;
    private static final int NORMAL = 7;

    public static BakedQuadsTransformer create() {
        return new BakedQuadsTransformerImpl();
    }

    @Override
    public BakedQuadsTransformer applyingColor(IntUnaryOperator indexToABGR) {
        this.inner = this.inner.andThen(BakedQuadsTransformerImpl.applyingColorInplace(indexToABGR));
        return this;
    }

    @Override
    public BakedQuadsTransformer applyingLightMap(int packedLight) {
        this.inner = this.inner.andThen(BakedQuadsTransformerImpl.applyingLightmapInplace(packedLight));
        return this;
    }

    @Override
    public BakedQuadsTransformer applyingTransform(Matrix4f transform) {
        this.inner = this.inner.andThen(BakedQuadsTransformerImpl.applyingTransformInplace(transform));
        this.directionRemap = d -> class_2350.method_23225((Matrix4fc)new Matrix4f((Matrix3fc)new Matrix3f((Matrix4fc)transform)), (class_2350)d);
        return this;
    }

    @Override
    public BakedQuadsTransformer applyingAmbientOcclusion(boolean ambientOcclusion) {
        return this;
    }

    @Override
    public BakedQuadsTransformer applyingShade(boolean shade) {
        this.shade = shade;
        return this;
    }

    @Override
    public BakedQuadsTransformer applyingTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
        return this;
    }

    @Override
    public BakedQuadsTransformer applyingEmissivity(int emissivity) {
        this.emissivity = emissivity;
        return this;
    }

    @Override
    public BakedQuadsTransformer applyingSprite(class_1058 sprite) {
        this.inner = this.inner.andThen(this.applyingSpriteInplace(sprite));
        this.sprite = sprite;
        return this;
    }

    @Override
    public class_777 transform(class_777 quad) {
        int[] v = Arrays.copyOf(quad.comp_3721(), quad.comp_3721().length);
        int tint = this.tintIndex == null ? quad.comp_3722() : this.tintIndex.intValue();
        boolean shade = this.shade == null ? quad.comp_3725() : this.shade.booleanValue();
        class_1058 sprite = this.sprite == null ? quad.comp_3724() : this.sprite;
        this.lastSpriteHack = quad.comp_3724();
        class_777 newQuad = new class_777(v, tint, (class_2350)this.directionRemap.apply(quad.comp_3723()), sprite, shade, Math.max(quad.comp_3726(), this.emissivity));
        this.inner.accept(newQuad);
        this.lastSpriteHack = null;
        if (this.emissivity != null) {
            BakedQuadBuilder builder = BakedQuadBuilderImpl.create(sprite, null);
            builder.fromVanilla(newQuad);
            builder.lightEmission(this.emissivity);
            newQuad = builder.build();
        }
        return newQuad;
    }

    private Consumer<class_777> applyingSpriteInplace(class_1058 sprite) {
        return q -> {
            class_1058 oldSprite = this.lastSpriteHack;
            int stride = BakedQuadsTransformerImpl.getStride();
            int[] v = q.comp_3721();
            float segmentWScale = (float)sprite.method_45851().method_45807() / (float)oldSprite.method_45851().method_45807();
            float segmentHScale = (float)sprite.method_45851().method_45815() / (float)oldSprite.method_45851().method_45815();
            for (int i = 0; i < 4; ++i) {
                int offset = i * stride + 4;
                float originalU = Float.intBitsToFloat(v[offset]);
                float originalV = Float.intBitsToFloat(v[offset + 1]);
                float u1 = (originalU - oldSprite.method_4594()) * segmentWScale;
                v[offset] = Float.floatToRawIntBits(u1 + sprite.method_4594());
                float v1 = (originalV - oldSprite.method_4593()) * segmentHScale;
                v[offset + 1] = Float.floatToRawIntBits(v1 + sprite.method_4593());
            }
        };
    }

    private static Consumer<class_777> applyingColorInplace(IntUnaryOperator indexToABGR) {
        return quad -> {
            int[] v = quad.comp_3721();
            int stride = BakedQuadsTransformerImpl.getStride();
            for (int i = 0; i < 4; ++i) {
                int i1;
                v[i * stride + 3] = i1 = indexToABGR.applyAsInt(i);
            }
        };
    }

    private static Consumer<class_777> applyingLightmapInplace(int packedLight) {
        return quad -> {
            int[] vertices = quad.comp_3721();
            for (int i = 0; i < 4; ++i) {
                vertices[i * BakedQuadsTransformerImpl.getStride() + 6] = packedLight;
            }
        };
    }

    private static Consumer<class_777> applyingTransformInplace(Matrix4f transform) {
        return quad -> {
            int[] v = quad.comp_3721();
            int stride = BakedQuadsTransformerImpl.getStride();
            for (int i = 0; i < 4; ++i) {
                int offset = i * stride + 0;
                float originalX = Float.intBitsToFloat(v[offset]) - 0.5f;
                float originalY = Float.intBitsToFloat(v[offset + 1]) - 0.5f;
                float originalZ = Float.intBitsToFloat(v[offset + 2]) - 0.5f;
                Vector4f vec = new Vector4f(originalX, originalY, originalZ, 1.0f);
                vec.mul((Matrix4fc)transform);
                vec.div(vec.w);
                v[offset] = Float.floatToRawIntBits(vec.x() + 0.5f);
                v[offset + 1] = Float.floatToRawIntBits(vec.y() + 0.5f);
                v[offset + 2] = Float.floatToRawIntBits(vec.z() + 0.5f);
            }
            Matrix3f normalTransform = new Matrix3f((Matrix4fc)transform).invert().transpose();
            for (int i = 0; i < 4; ++i) {
                int offset = i * stride + 7;
                int normalIn = v[offset];
                if ((normalIn & 0xFFFFFF) == 0) continue;
                float normalX = (float)((byte)(normalIn & 0xFF)) / 127.0f;
                float normalY = (float)((byte)(normalIn >> 8 & 0xFF)) / 127.0f;
                float normalZ = (float)((byte)(normalIn >> 16 & 0xFF)) / 127.0f;
                Vector3f vec = new Vector3f(normalX, normalY, normalZ);
                vec.mul((Matrix3fc)normalTransform);
                vec.normalize();
                v[offset] = (byte)(vec.x() * 127.0f) & 0xFF | ((byte)(vec.y() * 127.0f) & 0xFF) << 8 | ((byte)(vec.z() * 127.0f) & 0xFF) << 16 | normalIn & 0xFF000000;
            }
        };
    }

    private static int getStride() {
        return class_290.field_1590.getVertexSize();
    }
}

