/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.misc.struc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class DepthSearchTrie<K, KT, O, I> {
    protected final TrieNode<K, KT, O> root = new TrieNode();

    public void insert(List<K> paths, O object) {
        TrieNode current = this.root;
        for (int i = 0; i <= paths.size() - 1; ++i) {
            K folder = paths.get(i);
            KT folderType = this.getKeyOfType(folder);
            if (current.type == null) {
                current.type = this.getKeyOfType(paths.get(i));
            }
            current = current.children.computeIfAbsent(folder, a -> new TrieNode());
        }
        if (current.object == null) {
            current.object = new ArrayList();
        }
        current.object.add(object);
    }

    protected abstract KT getKeyOfType(K var1);

    protected abstract K getKeyFromType(Object var1, I var2);

    public boolean remove(List<K> path) {
        TrieNode<K, KT, O> current = this.getNode((I)path);
        if (current == null) {
            return false;
        }
        current.children.clear();
        current.object = null;
        return true;
    }

    public List<O> search(List<K> paths) {
        TrieNode<K, KT, O> current = this.getNode((I)paths);
        if (current == null) {
            return null;
        }
        return current.object;
    }

    @Nullable
    public List<O> search(I valueHolder) {
        TrieNode<K, KT, O> current = this.getNode(valueHolder);
        if (current == null) {
            return null;
        }
        return current.object;
    }

    @Nullable
    protected TrieNode<K, KT, O> getNode(List<K> path) {
        TrieNode<K, KT, O> current = this.root;
        for (K key : path) {
            current = current.children.getOrDefault(key, current.children.get(null));
            if (current != null) continue;
            return null;
        }
        return current;
    }

    @Nullable
    protected TrieNode<K, KT, O> getNode(I keyProvider) {
        TrieNode<K, KT, O> current = this.root;
        Object type;
        K folder;
        while ((folder = this.getKeyFromType(type = current.type, keyProvider)) != null) {
            TrieNode child = current.children.getOrDefault(folder, current.children.get(null));
            if (child == null) {
                return current;
            }
            current = child;
        }
        return current;
    }

    public void clear() {
        this.root.children.clear();
        this.root.object = null;
    }

    public Collection<K> listKeys(List<K> path) {
        TrieNode<K, KT, O> startNode = this.getNode((I)path);
        if (startNode != null) {
            return startNode.children.keySet();
        }
        return Collections.emptyList();
    }

    public void printTrie() {
        this.printNode(this.root, "", "root", true);
    }

    private void printNode(TrieNode<K, KT, O> node, String prefix, Object nodeName, boolean isTail) {
        if (nodeName == null) {
            nodeName = "*";
        }
        nodeName = String.valueOf(nodeName) + " (child type " + String.valueOf(node.type) + ")";
        System.out.println(prefix + (isTail ? "\\--- " : "|--- ") + String.valueOf(nodeName));
        if (node.object != null) {
            System.out.println(prefix + (isTail ? " " : "| ") + "[" + String.valueOf(node.object) + "]");
        }
        ArrayList childrenKeys = new ArrayList(node.children.keySet());
        for (int i = 0; i < childrenKeys.size(); ++i) {
            Object key = childrenKeys.get(i);
            TrieNode childNode = node.children.get(key);
            boolean isLastChild = i == childrenKeys.size() - 1;
            String newPrefix = prefix + (isTail ? "    " : "|   ");
            this.printNode(childNode, newPrefix, key, isLastChild);
        }
    }

    public void optimizeTree() {
        DepthSearchTrie.optimizeNode(this.root);
    }

    private static <K, KT, O> void optimizeNode(TrieNode<K, KT, O> node) {
        if (node == null) {
            return;
        }
        node.children.values().forEach(DepthSearchTrie::optimizeNode);
        HashMap toAdd = new HashMap();
        Iterator iterator = node.children.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            TrieNode child = entry.getValue();
            if (child.type != null || key != null) continue;
            int childSize = child.children.size();
            if (childSize == 1) {
                TrieNode onlyChild = child.children.values().iterator().next();
                iterator.remove();
                toAdd.put(entry.getKey(), onlyChild);
                continue;
            }
            if (childSize != 0 || node.object != null) continue;
            iterator.remove();
            node.object = child.object;
        }
        node.children.putAll(toAdd);
    }

    protected static class TrieNode<K, KT, O> {
        Map<K, TrieNode<K, KT, O>> children = new HashMap<K, TrieNode<K, KT, O>>();
        List<O> object;
        KT type = null;

        protected TrieNode() {
        }
    }
}

