/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.misc.struc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7654;

public class PropertiesUtils {
    public static Properties jsonToProperties(JsonElement element) {
        Properties properties = new Properties();
        if (element instanceof JsonObject) {
            JsonObject jo = (JsonObject)element;
            PropertiesUtils.iterateJsonObject(jo, properties, "");
        }
        return properties;
    }

    private static void iterateJsonObject(JsonObject jsonObject, Properties properties, String currentPath) {
        for (String key : jsonObject.keySet()) {
            JsonPrimitive s;
            String newPath;
            JsonElement value = jsonObject.get(key);
            String string = newPath = currentPath.isEmpty() ? key : currentPath + "." + key;
            if (value instanceof JsonObject) {
                JsonObject jo = (JsonObject)value;
                PropertiesUtils.iterateJsonObject(jo, properties, newPath);
                continue;
            }
            if (value instanceof JsonPrimitive && (s = (JsonPrimitive)value).isString()) {
                properties.setProperty(newPath, s.getAsString());
                continue;
            }
            if (!(value instanceof JsonArray)) continue;
            JsonArray ja = (JsonArray)value;
            StringBuilder builder = new StringBuilder();
            for (JsonElement e : ja) {
                JsonPrimitive p;
                if (!(e instanceof JsonPrimitive) || !(p = (JsonPrimitive)e).isString()) continue;
                builder.append(p.getAsString()).append(" ");
            }
            properties.setProperty(newPath, builder.toString().trim());
        }
    }

    public static JsonObject propertiesToJson(Properties props) {
        JsonObject root = new JsonObject();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            PropertiesUtils.insertNested(root, key, value);
        }
        return root;
    }

    private static void insertNested(JsonObject root, String dottedKey, String value) {
        String[] parts = dottedKey.split("\\.");
        JsonObject current = root;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!current.has(part) || !(current.get(part) instanceof JsonObject)) {
                current.add(part, (JsonElement)new JsonObject());
            }
            current = current.getAsJsonObject(part);
        }
        current.addProperty(parts[parts.length - 1], value);
    }

    public static Map<class_2960, Properties> gatherProperties(class_3300 resourceManager, String path) {
        class_7654 converter = new class_7654(path, ".properties");
        HashMap<class_2960, Properties> map = new HashMap<class_2960, Properties>();
        Map res = converter.method_45113(resourceManager);
        for (Map.Entry e : res.entrySet()) {
            try {
                BufferedReader reader = ((class_3298)e.getValue()).method_43039();
                try {
                    Properties properties = new Properties();
                    properties.load(reader);
                    class_2960 fileId = converter.method_45115((class_2960)e.getKey());
                    map.put(fileId, properties);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException ex) {
                Polytone.LOGGER.error("Couldn't parse property file {}:", e, (Object)ex);
            }
        }
        return map;
    }
}

