/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class IndexCompoundColorGetter
implements IColorGetter {
    final Int2ObjectMap<IColorGetter> getters = new Int2ObjectArrayMap();
    protected static final Codec<IndexCompoundColorGetter> DIRECT_CODEC = Codec.unboundedMap((Codec)Codec.STRING.flatXmap(s -> {
        try {
            int i = Integer.parseInt(s);
            return DataResult.success((Object)i);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Not a valid integer: " + s);
        }
    }, i -> DataResult.success((Object)String.valueOf(i))), Colormap.CODEC).xmap(IndexCompoundColorGetter::new, comp -> comp.getters).validate(c -> {
        if (c.getters.isEmpty()) {
            return DataResult.error(() -> "Must have at least 1 tint getter");
        }
        return DataResult.success((Object)c);
    });
    public static final Codec<IColorGetter> SINGLE_OR_MULTIPLE = Codec.withAlternative(Colormap.CODEC, DIRECT_CODEC, iColorGetter -> iColorGetter);

    private IndexCompoundColorGetter(Map<Integer, IColorGetter> map) {
        this.getters.putAll(map);
    }

    private IndexCompoundColorGetter() {
    }

    @Override
    public IColorGetter makeConcurrent() {
        HashMap<Integer, IColorGetter> newMap = new HashMap<Integer, IColorGetter>();
        for (Int2ObjectMap.Entry e : this.getters.int2ObjectEntrySet()) {
            newMap.put(e.getIntKey(), ((IColorGetter)e.getValue()).makeConcurrent());
        }
        return new IndexCompoundColorGetter(newMap);
    }

    @Override
    public boolean needsToFillTexture() {
        for (IColorGetter getter : this.getters.values()) {
            if (!getter.needsToFillTexture()) continue;
            return true;
        }
        return false;
    }

    public static IndexCompoundColorGetter createDefault(Set<Integer> tintIndexes, boolean triangular) {
        IndexCompoundColorGetter c = new IndexCompoundColorGetter();
        for (Integer i : tintIndexes) {
            c.getters.put(i.intValue(), (Object)(triangular ? Colormap.createDefTriangle() : Colormap.createDefSquare()));
        }
        return c;
    }

    public Int2ObjectMap<IColorGetter> getGetters() {
        return this.getters;
    }

    public int getColor(@Nullable BlockState blockState, @Nullable BlockAndTintGetter level, @Nullable BlockPos blockPos, int tintIndex) {
        BlockColor getter = (BlockColor)this.getters.get(tintIndex);
        if (getter == null) {
            getter = (BlockColor)this.getters.get(-1);
        }
        if (getter != null) {
            return getter.getColor(blockState, level, blockPos, tintIndex);
        }
        return -1;
    }

    public int getColor(ItemStack itemStack, int i) {
        ItemColor getter = (ItemColor)this.getters.get(i);
        if (getter == null) {
            getter = (ItemColor)this.getters.get(-1);
        }
        if (getter != null) {
            return getter.getColor(itemStack, i);
        }
        return -1;
    }

    @Override
    public int sampleColor(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable ItemStack item) {
        IColorGetter getter = (IColorGetter)this.getters.get(-1);
        if (getter != null) {
            return getter.sampleColor(state, pos, biome, item);
        }
        return -1;
    }
}

