/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Collection;
import net.mehvahdjukaar.polytone.dimension.DimensionTemplate;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionTarget {
    public static final Codec<DimensionTarget> CODEC = Codec.either(Targets.CODEC, DimensionTemplate.CODEC).xmap(DimensionTarget::new, d -> d.target);
    public static final DimensionTarget EMPTY = new DimensionTarget((Either<Targets, DimensionTemplate>)Either.left((Object)Targets.EMPTY));
    private final Either<Targets, DimensionTemplate> target;

    private DimensionTarget(Either<Targets, DimensionTemplate> target) {
        this.target = target;
    }

    public Collection<Holder<DimensionType>> getTargets(ResourceLocation fileId, RegistryAccess registryAccess) {
        HolderLookup.RegistryLookup reg = registryAccess.lookupOrThrow(Registries.DIMENSION_TYPE);
        if (this.target.left().isPresent()) {
            Targets tt = (Targets)this.target.left().get();
            return tt.compute(fileId, reg);
        }
        DimensionTemplate template = (DimensionTemplate)this.target.right().get();
        return reg.listElements().filter(h -> template.matches((DimensionType)h.value())).map(r -> r).toList();
    }
}

