/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.client.color.block.BlockColor;
import org.jetbrains.annotations.Nullable;

public record FluidPropertyModifier(Optional<? extends BlockColor> colormap, Optional<IColorGetter> fogColormap, Targets targets) {
    public static final Decoder<FluidPropertyModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> c.colormap), (App)Colormap.CODEC.optionalFieldOf("fog_colormap").forGetter(FluidPropertyModifier::fogColormap), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(FluidPropertyModifier::targets)).apply((Applicative)instance, FluidPropertyModifier::new));

    public FluidPropertyModifier merge(FluidPropertyModifier newMod) {
        return new FluidPropertyModifier(newMod.colormap.isPresent() ? newMod.colormap() : this.colormap(), newMod.fogColormap().isPresent() ? newMod.fogColormap() : this.fogColormap(), newMod.targets.merge(this.targets));
    }

    public static FluidPropertyModifier ofBlockColor(BlockColor colormap) {
        return new FluidPropertyModifier(Optional.of(colormap), Optional.empty(), Targets.EMPTY);
    }

    @Nullable
    public BlockColor getColormap() {
        return this.colormap.orElse(null);
    }

    @Nullable
    public BlockColor getFogColormap() {
        return this.fogColormap.orElse(null);
    }

    public boolean hasColormap() {
        return this.colormap.isPresent();
    }
}

