/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.mehvahdjukaar.polytone.particle.RotationProvider;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum RotationMode implements StringRepresentable,
RotationProvider
{
    LOOK_AT_XYZ,
    LOOK_AT_Y,
    LOOK_AT_X,
    LOOK_AT_Z,
    LOOK_AT_XZ,
    MOVEMENT_ALIGNED,
    LOOK_UP,
    LOOK_WEST,
    NONE;

    public static final Codec<RotationMode> CODEC;

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public void applyRotation(SingleQuadParticle particle, Quaternionf quaternionf, Camera camera, float partialTicks) {
        switch (this.ordinal()) {
            case 8: {
                break;
            }
            case 6: {
                quaternionf.identity();
                quaternionf.rotateX(1.5707964f);
                break;
            }
            case 7: {
                quaternionf.identity();
                quaternionf.rotateY(1.5707964f);
                break;
            }
            case 0: {
                SingleQuadParticle.FacingCameraMode.LOOKAT_XYZ.setRotation(quaternionf, camera, partialTicks);
                break;
            }
            case 1: {
                SingleQuadParticle.FacingCameraMode.LOOKAT_Y.setRotation(quaternionf, camera, partialTicks);
                break;
            }
            case 2: {
                quaternionf.set(camera.rotation().x, 0.0f, 0.0f, camera.rotation().w);
                break;
            }
            case 3: {
                quaternionf.set(0.0f, 0.0f, camera.rotation().z, camera.rotation().w);
                break;
            }
            case 4: {
                quaternionf.set(camera.rotation().x, 0.0f, camera.rotation().z, camera.rotation().w);
                break;
            }
            case 5: {
                Vec3 dir = new Vec3(particle.xd, particle.yd, particle.zd).normalize();
                Vec3 cameraLook = new Vec3(camera.getLookVector());
                Vec3 cross = dir.cross(cameraLook);
                double pitch = RotationMode.getPitch(dir);
                double yaw = RotationMode.getYaw(dir);
                Vector3f dirUp = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf);
                float roll = dirUp.angleSigned((Vector3fc)cross.toVector3f(), (Vector3fc)dir.toVector3f());
                quaternionf.rotateY((float)(-0.01745329238474369 * yaw));
                quaternionf.rotateX((float)(0.01745329238474369 * (pitch - 90.0)));
                quaternionf.rotateY(-roll - 1.5707964f);
            }
        }
    }

    @Override
    public boolean alwaysFacesCamera() {
        return this == LOOK_AT_XYZ || this == LOOK_AT_Y || this == MOVEMENT_ALIGNED;
    }

    public static double getPitch(Vec3 vec3) {
        return -Math.toDegrees(Math.asin(vec3.y));
    }

    public static double getYaw(Vec3 vec3) {
        return Math.toDegrees(Math.atan2(-vec3.x, vec3.z));
    }

    static {
        CODEC = StringRepresentable.fromEnum(RotationMode::values);
    }
}

