/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.sound.PolytoneSoundType;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Nullable;

public class SoundTypesManager
extends PartialReloader<Resources> {
    private final MapRegistry<SoundEvent> customSoundEvents = new MapRegistry("Custom Sound Events");
    private final MapRegistry<SoundType> customSoundTypes = new MapRegistry("Custom Sound Types");

    public SoundTypesManager() {
        super("custom_sound_types", "sound_types");
    }

    @Nullable
    public SoundType getCustomSoundType(ResourceLocation resourceLocation) {
        return this.customSoundTypes.getValue(resourceLocation);
    }

    @Override
    protected Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        Map<ResourceLocation, List<String>> types = CsvUtils.parseCsv(resourceManager, "sound_events");
        return new Resources((Map<ResourceLocation, JsonElement>)ImmutableMap.copyOf(jsons), (Map<ResourceLocation, List<String>>)ImmutableMap.copyOf(types));
    }

    @Override
    protected void parseWithLevel(Resources resources, RegistryOps<JsonElement> ops, RegistryAccess access) {
        for (Map.Entry<ResourceLocation, List<String>> entry : resources.soundEvents.entrySet()) {
            for (String s : entry.getValue()) {
                ResourceLocation id = entry.getKey().withPath(s);
                if (!this.customSoundEvents.containsKey(id) && !BuiltInRegistries.SOUND_EVENT.containsKey(id)) {
                    SoundEvent newSound = SoundEvent.createVariableRangeEvent((ResourceLocation)id);
                    this.customSoundEvents.register(id, newSound);
                    continue;
                }
                Polytone.LOGGER.error("Sound Event with id {} already exists! Ignoring.", (Object)id);
            }
        }
        for (Map.Entry<ResourceLocation, List<String>> entry : this.customSoundEvents.getEntries()) {
            ResourceLocation id = entry.getKey();
            SoundEvent sound = (SoundEvent)entry.getValue();
            PlatStuff.registerDynamic(BuiltInRegistries.SOUND_EVENT, id, sound);
        }
        for (Map.Entry<ResourceLocation, Object> entry : Parsed.batchParseOnlyEnabled(resources.soundTypes, PolytoneSoundType.DIRECT_CODEC, ops, "sound type")) {
            PolytoneSoundType soundType = (PolytoneSoundType)((Object)entry.getValue());
            ResourceLocation id = entry.getKey();
            this.customSoundTypes.register(id, soundType);
        }
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
        if (!this.customSoundEvents.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Sound Events from Resource Packs: {}", (Object)this.customSoundEvents.size(), (Object)(String.valueOf(this.customSoundEvents) + ". Remember to add them to sounds.json!"));
            Minecraft.getInstance().getSoundManager().reload();
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<ResourceLocation, SoundEvent> e : this.customSoundEvents.getEntries()) {
            ResourceLocation id = e.getKey();
            PlatStuff.unregisterDynamic(BuiltInRegistries.SOUND_EVENT, id);
        }
        this.customSoundTypes.clear();
        this.customSoundEvents.clear();
    }

    public boolean isDynamicSound(ResourceLocation entryId) {
        return this.customSoundEvents.containsKey(entryId);
    }

    public record Resources(Map<ResourceLocation, JsonElement> soundTypes, Map<ResourceLocation, List<String>> soundEvents) {
    }
}

