/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.tabs.ItemAddition;
import net.mehvahdjukaar.polytone.tabs.ItemPredicate;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record CreativeTabModifier(Optional<ItemStack> icon, Optional<Boolean> search, Optional<Integer> searchWidth, Optional<Boolean> canScroll, Optional<Boolean> showTitle, Optional<Component> name, Optional<ResourceLocation> backGroundLocation, Optional<ResourceLocation> tabsImage, Optional<List<ResourceLocation>> beforeTabs, Optional<List<ResourceLocation>> afterTabs, List<ItemPredicate> removals, List<ItemAddition> additions, boolean registerTab, Targets targets) {
    public static final Codec<Component> COMPONENT_CODEC = Codec.withAlternative((Codec)ComponentSerialization.CODEC, (Codec)ComponentSerialization.FLAT_CODEC, Function.identity());
    public static final Codec<CreativeTabModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecUtils.ITEM_OR_STACK.optionalFieldOf("icon").forGetter(CreativeTabModifier::icon), (App)Codec.BOOL.optionalFieldOf("search_bar").forGetter(CreativeTabModifier::search), (App)Codec.INT.optionalFieldOf("search_bar_width").forGetter(CreativeTabModifier::searchWidth), (App)Codec.BOOL.optionalFieldOf("can_scroll").forGetter(CreativeTabModifier::canScroll), (App)Codec.BOOL.optionalFieldOf("show_title").forGetter(CreativeTabModifier::showTitle), (App)COMPONENT_CODEC.optionalFieldOf("name").forGetter(CreativeTabModifier::name), (App)ResourceLocation.CODEC.optionalFieldOf("background").forGetter(CreativeTabModifier::backGroundLocation), (App)ResourceLocation.CODEC.optionalFieldOf("tabs_image").forGetter(CreativeTabModifier::tabsImage), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("before_tabs").forGetter(CreativeTabModifier::beforeTabs), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("after_tabs").forGetter(CreativeTabModifier::afterTabs), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("removals", List.of()).forGetter(CreativeTabModifier::removals), (App)ItemAddition.CODEC.listOf().optionalFieldOf("additions", List.of()).forGetter(CreativeTabModifier::additions), (App)Codec.BOOL.optionalFieldOf("create_new", (Object)false).forGetter(CreativeTabModifier::registerTab), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(CreativeTabModifier::targets)).apply((Applicative)i, CreativeTabModifier::new)).validate(m -> {
        if (m.registerTab && (!m.removals.isEmpty() || m.targets != Targets.EMPTY)) {
            return DataResult.error(() -> "Modifiers that register new creative tabs cannot have item removals or target existing tabs.");
        }
        return DataResult.success((Object)m);
    });

    public CreativeTabModifier merge(CreativeTabModifier newMod) {
        return new CreativeTabModifier(newMod.icon.isPresent() ? newMod.icon : this.icon, newMod.search.isPresent() ? newMod.search : this.search, newMod.searchWidth.isPresent() ? newMod.searchWidth : this.searchWidth, newMod.canScroll.isPresent() ? newMod.canScroll : this.canScroll, newMod.showTitle.isPresent() ? newMod.showTitle : this.showTitle, newMod.name.isPresent() ? newMod.name : this.name, newMod.backGroundLocation.isPresent() ? newMod.backGroundLocation : this.backGroundLocation, newMod.tabsImage.isPresent() ? newMod.tabsImage : this.tabsImage, newMod.beforeTabs.isPresent() ? newMod.beforeTabs : this.beforeTabs, newMod.afterTabs.isPresent() ? newMod.afterTabs : this.afterTabs, Utils.mergeList(newMod.removals, this.removals), Utils.mergeList(newMod.additions, this.additions), this.registerTab || newMod.registerTab, this.targets.merge(newMod.targets));
    }

    public CreativeTabModifier applyItemsAndAttributes(ItemToTabEvent event, RegistryAccess access) {
        for (ItemPredicate itemPredicate : this.removals) {
            event.removeItems(itemPredicate);
        }
        for (ItemAddition itemAddition : this.additions) {
            List<ItemStack> stacks = itemAddition.items();
            if (stacks == null) continue;
            if (itemAddition.inverse()) {
                ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
                List<Item> not = stacks.stream().map(ItemStack::getItem).toList();
                for (Item i : BuiltInRegistries.ITEM) {
                    if (not.contains(i)) continue;
                    newList.add(i.getDefaultInstance());
                }
                stacks = newList;
            }
            if (itemAddition.before()) {
                event.addBefore((Predicate<ItemStack>)itemAddition.predicate(), (ItemStack[])stacks.toArray(ItemStack[]::new));
                continue;
            }
            event.addAfter((Predicate<ItemStack>)itemAddition.predicate(), (ItemStack[])stacks.toArray(ItemStack[]::new));
        }
        return this.applyAttributes(event.getTab());
    }

    public CreativeTabModifier applyAttributes(ResourceKey<CreativeModeTab> key) {
        CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(key);
        if (tab == null) {
            Polytone.LOGGER.error("Could not find creative mode tab with ID {}. What?", key);
        }
        return PlatStuff.modifyTab(this, tab);
    }
}

