/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class ExpressionUtils {
    private static final RandomSource RANDOM_SOURCE = RandomSource.createNewThreadLocalInstance();
    private static final ThreadLocal<Long> LAST_SEED = new ThreadLocal();
    private static final Set<Function> NOISE_FUNCS = new HashSet<Function>();
    private static final Function RAND = new Function("rand", 0){

        public double apply(double ... args) {
            RANDOM_SOURCE.setSeed(LAST_SEED.get().longValue());
            return RANDOM_SOURCE.nextDouble();
        }
    };
    private static final Function RAND_INT = new Function("rand_int", 0){

        public double apply(double ... args) {
            RANDOM_SOURCE.setSeed(LAST_SEED.get().longValue());
            return RANDOM_SOURCE.nextInt();
        }
    };
    private static final Function RAND_LONG = new Function("rand_long", 0){

        public double apply(double ... args) {
            RANDOM_SOURCE.setSeed(LAST_SEED.get().longValue());
            return RANDOM_SOURCE.nextInt();
        }
    };
    private static final Function GAUSSIAN = new Function("gaussian", 0){

        public double apply(double ... args) {
            RANDOM_SOURCE.setSeed(LAST_SEED.get().longValue());
            return RANDOM_SOURCE.nextGaussian();
        }
    };
    private static final Function COS = new Function("cos", 1){

        public double apply(double ... args) {
            return Mth.cos((float)((float)args[0]));
        }
    };
    private static final Function SIN = new Function("sin", 1){

        public double apply(double ... args) {
            return Mth.sin((float)((float)args[0]));
        }
    };
    private static final Function RED = new Function("red", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.red((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function GREEN = new Function("green", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.green((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function BLUE = new Function("blue", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.blue((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function ALPHA = new Function("alpha", 1){

        public double apply(double ... args) {
            return (float)FastColor.ARGB32.alpha((int)((int)args[0])) / 255.0f;
        }
    };
    private static final Function COLOR = new Function("color", 4){

        public double apply(double ... args) {
            return FastColor.ARGB32.color((int)((int)(args[0] * 255.0)), (int)((int)(args[1] * 255.0)), (int)((int)(args[2] * 255.0)), (int)((int)(args[3] * 255.0)));
        }
    };
    private static final Function ATAN2 = new Function("atan2", 2){

        public double apply(double ... args) {
            return Mth.atan2((double)((float)args[0]), (double)args[1]);
        }
    };
    private static final Function STEP = new Function("step", 2){

        public double apply(double ... args) {
            return args[0] >= args[1] ? 1.0 : 0.0;
        }
    };
    private static final Function MAX = new Function("max", 2){

        public double apply(double ... args) {
            return Math.max(args[0], args[1]);
        }
    };
    private static final Function MIN = new Function("min", 2){

        public double apply(double ... args) {
            return Math.min(args[0], args[1]);
        }
    };
    private static final Function LERP = new Function("lerp", 3){

        public double apply(double ... args) {
            return Mth.lerp((double)args[0], (double)args[1], (double)args[2]);
        }
    };
    public static final Function SMOOTHSTEP = new Function("smoothstep", 3){

        public double apply(double ... args) {
            double t = Math.max(0.0, Math.min(1.0, (args[0] - args[1]) / (args[2] - args[1])));
            return t * t * (3.0 - 2.0 * t);
        }
    };
    private static final Operator EQUALS = new Operator("==", 2, true, 499){

        public double apply(double[] values) {
            return values[0] == values[1] ? 1.0 : 0.0;
        }
    };
    private static final Operator LESS_EQUAL = new Operator("<=", 2, true, 498){

        public double apply(double[] values) {
            if (values[0] <= values[1]) {
                return 1.0;
            }
            return 0.0;
        }
    };
    private static final Operator GREATER_EQUAL = new Operator(">=", 2, true, 497){

        public double apply(double[] values) {
            if (values[0] >= values[1]) {
                return 1.0;
            }
            return 0.0;
        }
    };
    private static final Operator LESS = new Operator("<", 2, true, 496){

        public double apply(double[] values) {
            return values[0] < values[1] ? 1.0 : 0.0;
        }
    };
    private static final Operator GREATER = new Operator(">", 2, true, 495){

        public double apply(double[] values) {
            return values[0] > values[1] ? 1.0 : 0.0;
        }
    };
    private static final Operator FACTORIAL = new Operator("!", 1, true, 10001){

        public double apply(double ... args) {
            int arg = (int)args[0];
            if ((double)arg != args[0]) {
                throw new IllegalArgumentException("Operand for factorial has to be an integer");
            }
            if (arg < 0) {
                throw new IllegalArgumentException("The operand of the factorial can not be less than zero");
            }
            double result = 1.0;
            for (int i = 1; i <= arg; ++i) {
                result *= (double)i;
            }
            return result;
        }
    };
    private static final Pattern HEX_PATTERN = Pattern.compile("(?:#|0x)[0-9a-fA-F]+");
    private static final RandomSource SECONDARY = RandomSource.createNewThreadLocalInstance();

    public static Function[] defFunc(Function ... others) {
        ArrayList<Function> list = new ArrayList<Function>();
        list.addAll(Arrays.asList(others));
        list.addAll(NOISE_FUNCS);
        list.addAll(List.of(COS, SIN, ATAN2, RAND, RAND_INT, RAND_LONG, GAUSSIAN, STEP, SMOOTHSTEP, MAX, MIN, LERP, RED, GREEN, BLUE, ALPHA, COLOR));
        return list.toArray(new Function[0]);
    }

    public static void regenNoiseFunctions(Set<Map.Entry<ResourceLocation, PerlinSimplexNoise>> noises) {
        NOISE_FUNCS.clear();
        for (Map.Entry<ResourceLocation, PerlinSimplexNoise> e : noises) {
            ResourceLocation res = e.getKey();
            final PerlinSimplexNoise noise = e.getValue();
            Object key = "noise_" + res.getNamespace() + "_" + res.getPath();
            NOISE_FUNCS.add(new Function((String)key, 2){

                public double apply(double ... args) {
                    return noise.getValue(args[0], args[1], false);
                }
            });
            if (!res.getNamespace().equals("minecraft")) continue;
            key = ((String)key).replace("minecraft_", "");
            NOISE_FUNCS.add(new Function((String)key, 2){

                public double apply(double ... args) {
                    return noise.getValue(args[0], args[1], false);
                }
            });
        }
        final PerlinSimplexNoise baseNoise = new PerlinSimplexNoise(RandomSource.create((long)0L), List.of(Integer.valueOf(1)));
        NOISE_FUNCS.add(new Function("noise", 2){

            public double apply(double ... args) {
                return baseNoise.getValue(args[0], args[1], false);
            }
        });
        if (NOISE_FUNCS.size() > 1) {
            Polytone.LOGGER.info("Registered custom noise functions: {}", NOISE_FUNCS.stream().map(Function::getName).toList());
        }
    }

    public static Operator[] defOp(Operator ... others) {
        return (Operator[])Stream.concat(Stream.of(EQUALS, GREATER, LESS, GREATER_EQUAL, LESS_EQUAL, FACTORIAL), Stream.of(others)).toArray(Operator[]::new);
    }

    public static String removeHex(String s) {
        Matcher matcher = HEX_PATTERN.matcher(s);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String hexString = matcher.group().replace("#", "").replace("0x", "");
            long decimalValue = Long.parseLong(hexString, 16);
            matcher.appendReplacement(sb, Long.toString(decimalValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void seedRandom(long seed) {
        LAST_SEED.set(seed);
    }

    public static void randomizeRandom() {
        ExpressionUtils.seedRandom(SECONDARY.nextLong());
    }
}

