/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MapRegistry<T>
implements Codec<T> {
    private final BiMap<ResourceLocation, T> map = HashBiMap.create();
    private final List<ResourceLocation> orderedKeys = new ArrayList<ResourceLocation>();
    private final String name;

    public MapRegistry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static <B> CodecMap<B> ofCodec(String name) {
        return new CodecMap(name);
    }

    public <B extends T> T register(ResourceLocation name, B value) {
        this.map.remove((Object)name);
        this.map.put((Object)name, value);
        if (!this.orderedKeys.contains(name)) {
            this.orderedKeys.add(name);
        }
        return value;
    }

    public <B extends T> T register(String name, B value) {
        this.register(ResourceLocation.parse((String)name), value);
        return value;
    }

    public void unregister(ResourceLocation name) {
        this.map.remove((Object)name);
        this.orderedKeys.remove(name);
    }

    @Nullable
    public T getValue(ResourceLocation name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public T getValue(String name) {
        return this.getValue(ResourceLocation.parse((String)name));
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return (ResourceLocation)this.map.inverse().get(value);
    }

    public Set<ResourceLocation> keySet() {
        return this.map.keySet();
    }

    public List<ResourceLocation> orderedKeys() {
        return this.orderedKeys;
    }

    public Set<T> getValues() {
        return this.map.values();
    }

    public Set<Map.Entry<ResourceLocation, T>> getEntries() {
        return this.map.entrySet();
    }

    public boolean containsKey(ResourceLocation name) {
        return this.map.containsKey((Object)name);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U json) {
        return ResourceLocation.CODEC.decode(ops, json).flatMap(pair -> {
            ResourceLocation id = (ResourceLocation)pair.getFirst();
            T value = this.getValue(id);
            return value == null ? DataResult.error(() -> "Could not find any entry with key '" + String.valueOf(id) + "' in registry [" + this.name + "] \n Known keys: " + String.valueOf(this.keySet())) : DataResult.success((Object)Pair.of(value, (Object)pair.getSecond()));
        });
    }

    public <U> DataResult<U> encode(T object, DynamicOps<U> ops, U prefix) {
        ResourceLocation id = this.getKey(object);
        return id == null ? DataResult.error(() -> "Could not find element '" + String.valueOf(object) + "' in registry [" + this.name + "]") : ops.mergeToPrimitive(prefix, ops.createString(id.toString()));
    }

    public void clear() {
        this.orderedKeys.clear();
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public static class CodecMap<T>
    extends MapRegistry<MapCodec<? extends T>> {
        public CodecMap(String name) {
            super(name);
        }

        @Override
        public <B extends T> MapCodec<B> register(ResourceLocation name, MapCodec<B> value) {
            super.register(name, value);
            return value;
        }

        @Override
        public <B extends T> MapCodec<B> register(String name, MapCodec<B> value) {
            return this.register(ResourceLocation.parse((String)name), value);
        }
    }
}

