/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils.codec;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class LenientHolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<Optional<Holder<E>>> elementCodec;
    private final Codec<List<Holder<E>>> homogenousListCodec;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> registryAwareCodec;

    private static <E> Codec<List<Holder<E>>> homogenousList(Codec<Optional<Holder<E>>> holderCodec, boolean disallowInline) {
        Codec codec = holderCodec.listOf().xmap(optionals -> optionals.stream().filter(Optional::isPresent).map(Optional::get).toList(), list -> list.stream().map(Optional::of).toList()).validate(ExtraCodecs.ensureHomogenous(Holder::kind));
        if (disallowInline) {
            return codec;
        }
        Codec singleCodec = holderCodec.xmap(optional -> optional.map(List::of).orElseGet(List::of), list -> list.size() == 1 ? Optional.ofNullable((Holder)list.getFirst()) : Optional.empty());
        return Codec.withAlternative((Codec)codec, (Codec)singleCodec);
    }

    public static <E> Codec<HolderSet<E>> create(ResourceKey<? extends Registry<E>> registryKey, Codec<Optional<Holder<E>>> holderCodec, boolean disallowSingleNonList) {
        return new LenientHolderSetCodec<E>(registryKey, holderCodec, disallowSingleNonList);
    }

    private LenientHolderSetCodec(ResourceKey<? extends Registry<E>> registryKey, Codec<Optional<Holder<E>>> elementCodec, boolean disallowInline) {
        this.registryKey = registryKey;
        this.elementCodec = elementCodec;
        this.homogenousListCodec = LenientHolderSetCodec.homogenousList(elementCodec, disallowInline);
        this.registryAwareCodec = Codec.either((Codec)TagKey.hashedCodec(registryKey), this.homogenousListCodec);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).getter(this.registryKey)).isPresent()) {
            HolderGetter holderGetter = (HolderGetter)optional.get();
            return this.registryAwareCodec.decode(dynamicOps, object).flatMap(pair -> {
                DataResult dataResult = (DataResult)((Either)pair.getFirst()).map(tagKey -> LenientHolderSetCodec.lookupTag(holderGetter, tagKey), list -> DataResult.success((Object)HolderSet.direct((List)list)));
                return dataResult.map(holderSet -> Pair.of((Object)holderSet, (Object)pair.getSecond()));
            });
        }
        return this.decodeWithoutRegistry(dynamicOps, object);
    }

    private static <E> DataResult<HolderSet<E>> lookupTag(HolderGetter<E> input, TagKey<E> tagKey) {
        return input.get(tagKey).map(e -> DataResult.success((Object)e)).orElseGet(() -> DataResult.error(() -> {
            String var10000 = String.valueOf(tagKey.location());
            return "Missing tag: '" + var10000 + "' in '" + String.valueOf(tagKey.registry().location()) + "'";
        }));
    }

    public <T> DataResult<T> encode(HolderSet<E> input, DynamicOps<T> ops, T prefix) {
        RegistryOps registryOps;
        Optional optional;
        if (ops instanceof RegistryOps && (optional = (registryOps = (RegistryOps)ops).owner(this.registryKey)).isPresent()) {
            if (!input.canSerializeIn((HolderOwner)optional.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(input) + " is not valid in current registry set");
            }
            return this.registryAwareCodec.encode((Object)input.unwrap().mapRight(List::copyOf), ops, prefix);
        }
        return this.encodeWithoutRegistry(input, ops, prefix);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> decodeWithoutRegistry(DynamicOps<T> ops, T input) {
        return this.elementCodec.listOf().decode(ops, input).flatMap(pair -> {
            ArrayList<Holder.Direct> list = new ArrayList<Holder.Direct>();
            for (Object o : (List)pair.getFirst()) {
                Holder holder = (Holder)o;
                if (!(holder instanceof Holder.Direct)) {
                    return DataResult.error(() -> "Can't decode element " + String.valueOf(holder) + " without registry");
                }
                Holder.Direct direct = (Holder.Direct)holder;
                list.add(direct);
            }
            return DataResult.success((Object)new Pair((Object)HolderSet.direct(list), pair.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(HolderSet<E> input, DynamicOps<T> ops, T prefix) {
        return this.homogenousListCodec.encode(input.stream().toList(), ops, prefix);
    }
}

