/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<ResourceKey<Biome>, BiomeSpecialEffects> vanillaEffects = new HashMap<ResourceKey<Biome>, BiomeSpecialEffects>();
    private final Map<ResourceKey<Biome>, BiomeEffectModifier> effectsToApply = new HashMap<ResourceKey<Biome>, BiomeEffectModifier>();
    private boolean needsDynamicApplication = true;
    private final Map<Biome, BiomeEffectModifier> fogParametersModifiers = new HashMap<Biome, BiomeEffectModifier>();

    public BiomeEffectsManager() {
        super("biome_modifiers", "biome_effects");
    }

    @Override
    public void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            Optional<BiomeEffectModifier> effect = Parsed.parseOptional(BiomeEffectModifier.CODEC, json, ops, id, "biome modifier");
            effect.ifPresent(e -> this.addEffect(id, (BiomeEffectModifier)e, access));
        }
    }

    private void addEffect(ResourceLocation pathId, BiomeEffectModifier mod, HolderLookup.Provider access) {
        HolderLookup.RegistryLookup registry = access.lookupOrThrow(Registries.BIOME);
        for (Holder biome : mod.targets().compute(pathId, registry)) {
            this.effectsToApply.merge((ResourceKey<Biome>)((ResourceKey)biome.unwrapKey().get()), mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void applyWithLevel(HolderLookup.Provider registryAccess, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        if (isLogIn) {
            this.vanillaEffects.clear();
        }
        HolderLookup.RegistryLookup biomeReg = registryAccess.lookupOrThrow(Registries.BIOME);
        for (Map.Entry<ResourceKey<Biome>, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            ResourceKey<Biome> biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.get(biomeId);
            if (!biome.isPresent()) continue;
            BiomeSpecialEffects old = modifier.apply((Biome)((Holder.Reference)biome.get()).value());
            this.vanillaEffects.put(biomeId, old);
            if (!modifier.modifyFogParameter()) continue;
            this.fogParametersModifiers.put((Biome)((Holder.Reference)biome.get()).value(), modifier);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void resetWithLevel(boolean isLogOff) {
        this.needsDynamicApplication = true;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            Registry biomeReg = level.registryAccess().lookupOrThrow(Registries.BIOME);
            for (Map.Entry<ResourceKey<Biome>, BiomeSpecialEffects> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.getOptional(v.getKey());
                biome.ifPresent(bio -> BiomeEffectModifier.applyEffects(bio, (BiomeSpecialEffects)v.getValue()));
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
        this.fogParametersModifiers.clear();
    }

    public BiomeEffectModifier getFogModifier(Biome value) {
        return this.fogParametersModifiers.get(value);
    }
}

