/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;

public interface BlockSetTypeProvider {
    public static final Codec<BlockSetTypeProvider> CODEC = new ReferenceOrDirectCodec<Custom>(Polytone.BLOCK_SET.byNameCodec(), Custom.CODEC);

    public BlockSetType getOrCreate(BlockSetType var1, Optional<SoundType> var2);

    public record Custom(Optional<SoundEvent> doorClose, Optional<SoundEvent> doorOpen, Optional<SoundEvent> trapdoorClose, Optional<SoundEvent> trapdoorOpen, Optional<SoundEvent> pressurePlateClickOff, Optional<SoundEvent> pressurePlateClickOn, Optional<SoundEvent> buttonClickOff, Optional<SoundEvent> buttonClickOn) implements BlockSetTypeProvider
    {
        public static final Codec<Custom> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("door_close").forGetter(Custom::doorClose), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("door_open").forGetter(Custom::doorOpen), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("trapdoor_close").forGetter(Custom::trapdoorClose), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("trapdoor_open").forGetter(Custom::trapdoorOpen), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("pressure_plate_click_off").forGetter(Custom::pressurePlateClickOff), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("pressure_plate_click_on").forGetter(Custom::pressurePlateClickOn), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("button_click_off").forGetter(Custom::buttonClickOff), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("button_click_on").forGetter(Custom::buttonClickOn)).apply((Applicative)instance, Custom::new));

        @Override
        public BlockSetType getOrCreate(BlockSetType original, Optional<SoundType> customSound) {
            return new BlockSetType(Polytone.BLOCK_SET.getNextName(), original.canOpenByHand(), original.canOpenByWindCharge(), original.canButtonBeActivatedByArrows(), original.pressurePlateSensitivity(), customSound.orElse(original.soundType()), this.doorClose.orElse(original.doorClose()), this.doorOpen.orElse(original.doorOpen()), this.trapdoorClose.orElse(original.trapdoorClose()), this.trapdoorOpen.orElse(original.trapdoorOpen()), this.pressurePlateClickOff.orElse(original.pressurePlateClickOff()), this.pressurePlateClickOn.orElse(original.pressurePlateClickOn()), this.buttonClickOff.orElse(original.buttonClickOff()), this.buttonClickOn.orElse(original.buttonClickOn()));
        }
    }

    public record Vanilla(BlockSetType vanilla) implements BlockSetTypeProvider
    {
        @Override
        public BlockSetType getOrCreate(BlockSetType original, Optional<SoundType> customSound) {
            if (customSound.isEmpty() && original.canOpenByHand() == this.vanilla.canOpenByHand()) {
                return this.vanilla;
            }
            return new BlockSetType(Polytone.BLOCK_SET.getNextName(), original.canOpenByHand(), original.canOpenByWindCharge(), original.canButtonBeActivatedByArrows(), original.pressurePlateSensitivity(), customSound.orElse(this.vanilla.soundType()), this.vanilla.doorClose(), this.vanilla.doorOpen(), this.vanilla.trapdoorClose(), this.vanilla.trapdoorOpen(), this.vanilla.pressurePlateClickOff(), this.vanilla.pressurePlateClickOn(), this.vanilla.buttonClickOff(), this.vanilla.buttonClickOn());
        }
    }
}

