/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.DustParticleOptionAccessor;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.state.ExperienceOrbRenderState;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private static final int DEFAULT_COLOR = ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    private final Object2IntMap<MapColor> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<DyeColor, Integer> vanillaFireworkColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaDiffuseColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaTextColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<ChatFormatting, Integer> vanillaChatFormatting = new EnumMap<ChatFormatting, Integer>(ChatFormatting.class);
    private final Object2IntMap<MobEffect> vanillaEffectColors = new Object2IntOpenHashMap();
    private final Map<MobEffect, Function<MobEffectInstance, ParticleOptions>> vanillaEffectParticles = new HashMap<MobEffect, Function<MobEffectInstance, ParticleOptions>>();
    private final EnumMap<BorderStatus, Integer> vanillaBorderStatus = new EnumMap(BorderStatus.class);
    private final Map<DyeColor, Integer> customSheepColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    protected final int[] originalRedstoneWireColors = Arrays.copyOf(RedStoneWireBlock.COLORS, RedStoneWireBlock.COLORS.length);
    @Nullable
    private BlockContextExpression xpOrbColor;
    @Nullable
    private BlockContextExpression xpOrbColorR;
    @Nullable
    private BlockContextExpression xpOrbColorG;
    @Nullable
    private BlockContextExpression xpOrbColorB;
    private Integer xpBar = null;
    private Integer splash = null;
    private Integer enchantTableXp = null;

    public ColorManager() {
        super("colo_manager", "color.properties", "colors.json", new String[]{"polytone", "colormatic", "vanadium", "optifine"});
    }

    public Integer getXpBar() {
        return this.xpBar;
    }

    public Integer getSplash() {
        return this.splash;
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        ArrayList<ResourceLocation> keySet = new ArrayList<ResourceLocation>(jsons.keySet());
        Lists.reverse(keySet);
        for (ResourceLocation k : keySet) {
            JsonElement root = jsons.get(k);
            try {
                this.parseColorJson(root, k);
            }
            catch (Exception e1) {
                Polytone.LOGGER.error("Failed to parse color JSON in file {}", (Object)k, (Object)e1);
            }
        }
        this.regenSheepColors();
    }

    private void parseColorJson(JsonElement root, ResourceLocation fileId) {
        JsonObject obj = root.getAsJsonObject();
        ColorManager.doWith(obj, "map", (k, v) -> {
            MapColor color = MapColorHelper.byName(k);
            if (color != null) {
                int col = ColorManager.parseHex(v);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.col);
                }
                color.col = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", k);
            }
        });
        ColorManager.doWith(obj, "dye", (k, v) -> {
            DyeColor color = DyeColor.byName((String)k, null);
            if (color == null) {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", k);
                return;
            }
            for (Map.Entry<String, JsonElement> entry : ColorManager.entries(v)) {
                String param = entry.getKey();
                int col = ColorManager.parseHex(entry.getValue());
                switch (param) {
                    case "diffuse": {
                        if (!this.vanillaDiffuseColors.containsKey(color)) {
                            this.vanillaDiffuseColors.put(color, color.getTextureDiffuseColor());
                        }
                        color.textureDiffuseColor = ARGB.opaque((int)col);
                        break;
                    }
                    case "firework": {
                        if (!this.vanillaFireworkColors.containsKey(color)) {
                            this.vanillaFireworkColors.put(color, color.fireworkColor);
                        }
                        color.fireworkColor = col;
                        break;
                    }
                    case "text": {
                        if (!this.vanillaTextColors.containsKey(color)) {
                            this.vanillaTextColors.put(color, color.textColor);
                        }
                        color.textColor = col;
                    }
                }
            }
        });
        ColorManager.doWith(obj, "particle", (k, v) -> {
            ResourceLocation id = ResourceLocation.parse((String)k.replace("\\", ""));
            try {
                int hex = ColorManager.parseHex(v);
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
            }
            catch (Exception e) {
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, v.getAsString());
            }
        });
        ColorManager.doWith(obj, "world_border", (k, v) -> {
            BorderStatus status = BorderStatus.valueOf((String)k.toLowerCase(Locale.ROOT));
            int col = ColorManager.parseHex(v);
            if (!this.vanillaBorderStatus.containsKey(status)) {
                this.vanillaBorderStatus.put(status, status.getColor());
            }
            status.color = col;
        });
        ColorManager.doWith(obj, "effect", (k, v) -> {
            ResourceLocation id = ResourceLocation.parse((String)k.replace("\\", ""));
            ParticleOptions particle = (ParticleOptions)ColorManager.get(v, "particle", ParticleTypes.CODEC);
            String color = ColorManager.getString(v, "color");
            Integer col = color == null && v instanceof JsonPrimitive ? Integer.valueOf(ColorManager.parseHex(v)) : Integer.valueOf(ColorManager.parseHex(color));
            if (!id.getPath().equals("empty")) {
                if (id.getPath().equals("water")) {
                    PotionContents.BASE_POTION_COLOR = col;
                } else {
                    MobEffect effect = BuiltInRegistries.MOB_EFFECT.getOptional(id).orElse(null);
                    if (effect != null) {
                        if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                            this.vanillaEffectColors.put((Object)effect, effect.getColor());
                        }
                        effect.color = col;
                        if (particle != null) {
                            if (!this.vanillaEffectParticles.containsKey(effect)) {
                                this.vanillaEffectParticles.put(effect, effect.particleFactory);
                            }
                            effect.particleFactory = mobEffectInstance -> particle;
                        }
                    } else {
                        Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                    }
                }
            }
        });
        ColorManager.doWith(obj, "sheep", (k, v) -> {
            DyeColor color = DyeColor.byName((String)k, null);
            if (color != null) {
                int col = ARGB.opaque((int)ColorManager.parseHex(v));
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", k);
            }
        });
        ColorManager.doWith(obj, "xporb", (k, v) -> {
            switch (k) {
                case "color": {
                    this.xpOrbColor = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "red": {
                    this.xpOrbColorR = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "green": {
                    this.xpOrbColorG = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "blue": {
                    this.xpOrbColorB = new BlockContextExpression(v.getAsString());
                }
            }
        });
        ColorManager.doWith(obj, "redstone", (k, v) -> {
            int code = Integer.parseInt(k);
            if (code < RedStoneWireBlock.COLORS.length) {
                int col = ColorManager.parseHex(v);
                float[] rgb = ColorUtils.unpack(col);
                RedStoneWireBlock.COLORS[code] = ARGB.colorFromFloat((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                if (code == 15) {
                    int maxPower;
                    DustParticleOptions.REDSTONE_PARTICLE_COLOR = maxPower = ARGB.colorFromFloat((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                    ((DustParticleOptionAccessor)DustParticleOptions.REDSTONE).setColor(maxPower);
                }
            } else {
                Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
            }
        });
        ColorManager.doWith(obj, "text", (k, v) -> {
            int col = ColorManager.parseHex(v);
            ChatFormatting text = null;
            if (k.equals("splash")) {
                this.splash = col;
            } else if (k.equals("xpbar")) {
                this.xpBar = col;
            } else if (k.startsWith("code:")) {
                String s = k.substring(5);
                int code = Integer.parseInt(s);
                text = ChatFormatting.getById((int)code);
            } else {
                text = ChatFormatting.getByName((String)k);
            }
            if (text != null) {
                if (!this.vanillaChatFormatting.containsKey(text)) {
                    this.vanillaChatFormatting.put(text, text.getColor());
                }
                text.color = col;
                TextColor tc = TextColor.fromLegacyFormat((ChatFormatting)text);
                tc.value = col;
            }
        });
        ColorManager.doWith(obj, "palette", (k, v) -> {
            if (k.equals("block") && v.isJsonObject()) {
                for (Map.Entry<String, JsonElement> entry : ColorManager.getEntries(v.getAsJsonObject(), "block")) {
                    String path = entry.getKey().replace("~/colormap/", fileId.getNamespace() + ":");
                    Polytone.BLOCK_MODIFIERS.addSimpleColormap(ResourceLocation.parse((String)path), entry.getValue().getAsString());
                }
            }
        });
    }

    private static void doWith(JsonObject obj, String key, BiConsumer<String, JsonElement> entryHandler) {
        try {
            if (obj.has(key)) {
                JsonObject sub = GsonHelper.getAsJsonObject((JsonObject)obj, (String)key);
                for (Map.Entry entry : sub.entrySet()) {
                    entryHandler.accept((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }
        catch (JsonParseException e) {
            throw new JsonParseException("Failed to parse color JSON for key: " + key, (Throwable)e);
        }
    }

    private static Set<Map.Entry<String, JsonElement>> getEntries(JsonObject element, String key) {
        JsonElement elements = element.get(key);
        if (elements != null && elements.isJsonObject()) {
            return elements.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static <T> T get(JsonElement element, String key, Codec<T> codec) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null) {
            return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)joo).getOrThrow()).getFirst();
        }
        return null;
    }

    private static String getString(JsonElement element, String key) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null && joo.isJsonPrimitive() && joo.getAsJsonPrimitive().isString()) {
            return joo.getAsString();
        }
        return null;
    }

    private static Set<Map.Entry<String, JsonElement>> entries(JsonElement element) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static int parseHex(JsonElement obj) {
        if (obj instanceof JsonPrimitive) {
            JsonPrimitive value = (JsonPrimitive)obj;
            String str = value.getAsString();
            return ColorManager.parseHex(str);
        }
        throw new JsonParseException("Failed to parse object " + String.valueOf(obj) + ". Expected a String");
    }

    private static int parseHex(String str) {
        str = str.replace("#", "").replace("0x", "");
        return Integer.parseInt(str.trim(), 16);
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        MobEffect effect;
        MapColor color;
        PotionContents.BASE_POTION_COLOR = 3694022;
        this.xpBar = null;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (MapColor)entry.getKey();
            color.col = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.textureDiffuseColor = (Integer)entry.getValue();
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.fireworkColor = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.textColor = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaChatFormatting.entrySet()) {
            ChatFormatting text = (ChatFormatting)entry.getKey();
            text.color = (Integer)entry.getValue();
            TextColor tc = TextColor.fromLegacyFormat((ChatFormatting)text);
            tc.value = (Integer)entry.getValue();
        }
        this.vanillaChatFormatting.clear();
        for (Object2IntMap.Entry entry : this.vanillaEffectColors.object2IntEntrySet()) {
            effect = (MobEffect)entry.getKey();
            effect.color = entry.getIntValue();
        }
        this.vanillaEffectColors.clear();
        for (Map.Entry entry : this.vanillaEffectParticles.entrySet()) {
            effect = (MobEffect)entry.getKey();
            effect.particleFactory = (Function)entry.getValue();
        }
        this.vanillaEffectParticles.clear();
        for (Map.Entry entry : this.vanillaBorderStatus.entrySet()) {
            BorderStatus status = (BorderStatus)entry.getKey();
            status.color = (Integer)entry.getValue();
        }
        this.vanillaBorderStatus.clear();
        RedStoneWireBlock.COLORS = Arrays.copyOf(this.originalRedstoneWireColors, this.originalRedstoneWireColors.length);
        DustParticleOptions.REDSTONE_PARTICLE_COLOR = DEFAULT_COLOR;
        ((DustParticleOptionAccessor)DustParticleOptions.REDSTONE).setColor(DustParticleOptions.REDSTONE_PARTICLE_COLOR);
    }

    public void regenSheepColors() {
        Sheep.COLOR_BY_DYE = new EnumMap(DyeColor.class);
        for (DyeColor d : DyeColor.values()) {
            Sheep.COLOR_BY_DYE.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        Sheep.COLOR_BY_DYE.putAll(this.customSheepColors);
        this.customSheepColors.clear();
    }

    public float @Nullable [] getXpOrbColor(ExperienceOrbRenderState orb, float partialTicks) {
        Vec3 orbPos = new Vec3(orb.x, orb.y, orb.z);
        ClientLevel level = Minecraft.getInstance().level;
        if (this.xpOrbColor != null) {
            int color = (int)this.xpOrbColor.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
            return ColorUtils.unpack(color);
        }
        if (this.xpOrbColorR == null && this.xpOrbColorG == null && this.xpOrbColorB == null) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (this.xpOrbColorR != null) {
            r = (float)this.xpOrbColorR.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
        }
        if (this.xpOrbColorG != null) {
            g = (float)this.xpOrbColorG.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
        }
        if (this.xpOrbColorB != null) {
            b = (float)this.xpOrbColorB.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
        }
        return new float[]{r, g, b};
    }
}

