/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import net.mehvahdjukaar.polytone.item.BarColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface IColorGetter
extends BlockColor,
BarColor {
    default public IColorGetter makeConcurrent() {
        return this;
    }

    public record OfItem(BarColor ic) implements IColorGetter
    {
        public int getColor(BlockState state, BlockAndTintGetter reader, BlockPos pos, int tintIndex) {
            return this.ic.getItemColor(ItemStack.EMPTY, tintIndex);
        }

        @Override
        public int getItemColor(ItemStack itemStack, int i) {
            return this.ic.getItemColor(itemStack, i);
        }
    }

    public record ofColorResolver(BlockColor bc, ColorResolver cr) implements IColorGetter,
    ColorResolver
    {
        public int getColor(BlockState state, @Nullable BlockAndTintGetter reader, @Nullable BlockPos pos, int tintIndex) {
            return this.bc.getColor(state, reader, pos, tintIndex);
        }

        @Override
        public int getItemColor(ItemStack stack, int tintIndex) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel world = mc.level;
            if (world == null) {
                return -1;
            }
            BlockPos pos = mc.player.blockPosition();
            BlockState state = world.getBlockState(pos);
            return this.bc.getColor(state, (BlockAndTintGetter)world, pos, tintIndex) | 0xFF000000;
        }

        public int getColor(Biome biome, double d, double e) {
            return this.cr.getColor(biome, d, e);
        }
    }

    public record OfBlock(BlockColor bc) implements IColorGetter
    {
        public int getColor(BlockState state, BlockAndTintGetter reader, BlockPos pos, int tintIndex) {
            return this.bc.getColor(state, reader, pos, tintIndex);
        }

        @Override
        public int getItemColor(ItemStack itemStack, int i) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel world = mc.level;
            if (world == null) {
                return -1;
            }
            BlockPos pos = mc.player.blockPosition();
            BlockState state = world.getBlockState(pos);
            return this.bc.getColor(state, (BlockAndTintGetter)world, pos, i) | 0xFF000000;
        }
    }
}

