/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColormapNumberProvider {
    public static final MapRegistry<IColormapNumberProvider> BUILTIN_PROVIDERS = new MapRegistry("Colormap Number Providers");
    public static final Codec<IColormapNumberProvider> CODEC = new ReferenceOrDirectCodec<ColormapExpressionProvider>(BUILTIN_PROVIDERS, ColormapExpressionProvider.CODEC, true);
    public static final IColormapNumberProvider ZERO = BUILTIN_PROVIDERS.register("zero", new Const(0.0f));
    public static final IColormapNumberProvider ONE = BUILTIN_PROVIDERS.register("one", new Const(1.0f));
    public static final IColormapNumberProvider DAY_TIME = BUILTIN_PROVIDERS.register("day_time", (state, pos, biome, mapper, stack) -> (float)(1.0 - ClientFrameTicker.getDayTime() % 24000.0 / 24000.0));
    public static final IColormapNumberProvider TEMPERATURE = BUILTIN_PROVIDERS.register("temperature", new IColormapNumberProvider(){

        @Override
        public float getValue(BlockState state, @NotNull BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((Biome)biome).temperature;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider LEGACY_TEMPERATURE = BUILTIN_PROVIDERS.register("legacy_temperature", new IColormapNumberProvider(){

        @Override
        public float getValue(BlockState state, @NotNull BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            return biome == null ? 0.0f : biome.getTemperature(pos, Minecraft.getInstance().level.getSeaLevel());
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider DOWNFALL = BUILTIN_PROVIDERS.register("downfall", new IColormapNumberProvider(){

        @Override
        public float getValue(BlockState state, @NotNull BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((Biome)biome).downfall;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider BIOME_ID = BUILTIN_PROVIDERS.register("biome_id", new IColormapNumberProvider(){

        @Override
        public float getValue(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            if (biome == null) {
                return 0.0f;
            }
            return 1.0f - mapper.getIndex(biome);
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider Y_LEVEL = BUILTIN_PROVIDERS.register("y_level", new IColormapNumberProvider(){

        @Override
        public float getValue(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            if (pos == null) {
                return 64.0f;
            }
            RandomSource rs = RandomSource.create((long)((long)pos.hashCode() * pos.asLong()));
            float yVariance = 4.0f;
            float v = yVariance * (rs.nextFloat() - 0.5f);
            return 1.0f - ((float)(pos.getY() + 64) + v) / 256.0f;
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider DAMAGE = BUILTIN_PROVIDERS.register("item_damage", new IColormapNumberProvider(){

        @Override
        public float getValue(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            if (stack == null) {
                return 0.0f;
            }
            return 1.0f - (float)stack.getDamageValue() / (float)stack.getMaxDamage();
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });

    public float getValue(@Nullable BlockState var1, @Nullable BlockPos var2, @Nullable Biome var3, @Nullable BiomeIdMapper var4, @Nullable ItemStack var5);

    default public boolean usesBiome() {
        return true;
    }

    default public boolean usesPos() {
        return true;
    }

    default public boolean usesState() {
        return true;
    }

    default public IColormapNumberProvider createConcurrent() {
        return this;
    }

    public record Const(float c) implements IColormapNumberProvider
    {
        @Override
        public float getValue(BlockState state, @NotNull BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
            return this.c;
        }

        @Override
        public boolean usesState() {
            return false;
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }
    }
}

