/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.fluid.neoforge.FluidPropertiesManagerImpl;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidPropertiesManager
extends JsonImgPartialReloader {
    private final Map<Fluid, FluidPropertyModifier> modifiers = new HashMap<Fluid, FluidPropertyModifier>();
    private Map<ResourceLocation, Parsed<FluidPropertyModifier>> extraModifiers;
    private Map<ResourceLocation, ArrayImage> extraImages;
    private ColorResolver vanillaWaterColorResolver = null;

    public FluidPropertiesManager() {
        super("fluid_modifiers", "fluid_properties");
    }

    public void addConvertedBlockProperties(Map<ResourceLocation, Parsed<FluidPropertyModifier>> modifiers, Map<ResourceLocation, ArrayImage> textures) {
        this.extraImages = textures;
        this.extraModifiers = modifiers;
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>();
        Map<ResourceLocation, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new JsonImgPartialReloader.Resources((Map<ResourceLocation, JsonElement>)ImmutableMap.copyOf(jsons), (Map<ResourceLocation, ArrayImage>)ImmutableMap.copyOf(textures));
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        ResourceLocation id;
        Object modifier;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        LinkedListMultimap parsedModifiers = LinkedListMultimap.create();
        this.extraModifiers.forEach((arg_0, arg_1) -> ((LinkedListMultimap)parsedModifiers).put(arg_0, arg_1));
        textures.putAll(this.extraImages);
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id2 = entry.getKey();
            modifier = Parsed.parseAlways(FluidPropertyModifier.CODEC, json, ops, id2, "fluid modifier");
            parsedModifiers.put((Object)id2, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entries()) {
            id = (ResourceLocation)entry.getKey();
            Parsed parsed = (Parsed)entry.getValue();
            modifier = (FluidPropertyModifier)parsed.getResultOrPartial();
            if (!((FluidPropertyModifier)modifier).hasColormap() && textures.containsKey(id)) {
                modifier = ((FluidPropertyModifier)modifier).merge(FluidPropertyModifier.ofBlockColor(Colormap.createDefTriangle()));
            }
            BlockColor tint = ((FluidPropertyModifier)modifier).getColormap();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, (FluidPropertyModifier)modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, new FluidPropertyModifier(Optional.of(defaultColormap), Optional.empty(), Optional.empty(), Optional.empty(), Targets.EMPTY));
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
        if (!this.modifiers.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Fluid Modifiers", (Object)this.modifiers.size());
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.modifiers.clear();
        FluidPropertiesManager.clearSpecial();
        if (this.vanillaWaterColorResolver != null) {
            BiomeColors.WATER_COLOR_RESOLVER = this.vanillaWaterColorResolver;
        }
        this.vanillaWaterColorResolver = null;
    }

    private void addModifier(ResourceLocation pathId, FluidPropertyModifier mod) {
        for (Holder fluid : mod.targets().compute(pathId, BuiltInRegistries.FLUID)) {
            BlockColor blockColor;
            Fluid f = (Fluid)fluid.value();
            this.modifiers.merge(f, mod, FluidPropertyModifier::merge);
            FluidPropertiesManager.tryAddSpecial(f, mod);
            if (fluid.value() != Fluids.WATER || !((blockColor = mod.getColormap()) instanceof Colormap)) continue;
            Colormap c = (Colormap)blockColor;
            this.vanillaWaterColorResolver = BiomeColors.WATER_COLOR_RESOLVER;
            BiomeColors.WATER_COLOR_RESOLVER = c;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void tryAddSpecial(Fluid fluid, FluidPropertyModifier colormap) {
        void var1_1;
        FluidPropertiesManagerImpl.tryAddSpecial(fluid, (FluidPropertyModifier)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearSpecial() {
        FluidPropertiesManagerImpl.clearSpecial();
    }

    public FluidPropertyModifier getModifier(Fluid water) {
        return this.modifiers.get(water);
    }
}

