/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.Nullable;

public record ItemModifier(Optional<IColorGetter> barColor, Optional<Rarity> rarity, List<Component> tooltips, List<Pattern> removedTooltips, List<ItemModelOverride> customModels, Targets targets) {
    public static final Codec<ItemModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Colormap.CODEC.optionalFieldOf("bar_color").forGetter(ItemModifier::barColor), (App)Rarity.CODEC.optionalFieldOf("rarity").forGetter(ItemModifier::rarity), (App)CreativeTabModifier.COMPONENT_CODEC.listOf().optionalFieldOf("tooltips", List.of()).forGetter(ItemModifier::tooltips), (App)ExtraCodecs.PATTERN.listOf().optionalFieldOf("removed_tooltips", List.of()).forGetter(ItemModifier::removedTooltips), (App)ItemModelOverride.CODEC.listOf().optionalFieldOf("custom_models", List.of()).forGetter(ItemModifier::customModels), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(ItemModifier::targets)).apply((Applicative)instance, ItemModifier::new));
    public static final Codec<Partial> CODEC_ONLY_MODELS = RecordCodecBuilder.create(instance -> instance.group((App)ItemModelOverride.CODEC_MODEL_ONLY.listOf().optionalFieldOf("custom_models", List.of()).forGetter(Partial::customModels)).apply((Applicative)instance, Partial::new));

    public static ItemModifier ofBarColor(Colormap colormap) {
        return new ItemModifier(Optional.of(colormap), Optional.empty(), List.of(), List.of(), List.of(), Targets.EMPTY);
    }

    public ItemModifier merge(ItemModifier newMod) {
        return new ItemModifier(newMod.barColor.isPresent() ? newMod.barColor : this.barColor, newMod.rarity.isPresent() ? newMod.rarity : this.rarity, Utils.mergeList(newMod.tooltips, this.tooltips), Utils.mergeList(newMod.removedTooltips, this.removedTooltips), Utils.mergeList(newMod.customModels, this.customModels), newMod.targets.merge(this.targets));
    }

    public ItemModifier apply(Item item) {
        Rarity oldRarity = null;
        if (this.rarity.isPresent()) {
            DataComponentMap components = item.components();
            oldRarity = (Rarity)components.get(DataComponents.RARITY);
            DataComponentMap.Builder builder = DataComponentMap.builder();
            builder.addAll(components);
            builder.set(DataComponents.RARITY, (Object)this.rarity.get());
            item.components = builder.build();
        }
        return new ItemModifier(Optional.empty(), Optional.ofNullable(oldRarity), List.of(), List.of(), List.of(), Targets.EMPTY);
    }

    @Nullable
    public Integer getBarColor(ItemStack itemStack) {
        return this.barColor.map(c -> c.getItemColor(itemStack, 0)).orElse(null);
    }

    public IColorGetter getBarColor() {
        return this.barColor.orElse(null);
    }

    public boolean hasBarColor() {
        return this.barColor.isPresent();
    }

    public void modifyTooltips(List<Component> tooltips) {
        tooltips.removeIf(t -> this.removedTooltips.stream().anyMatch(p -> p.matcher(t.getString()).matches()));
        tooltips.addAll(this.tooltips);
    }

    public boolean shouldAttachToItem() {
        return !this.tooltips.isEmpty() || !this.removedTooltips.isEmpty() || this.barColor.isPresent();
    }

    public record Partial(List<ItemModelOverride.Partial> customModels) {
    }
}

