/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.block.TickSource;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.utils.BiggerCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record BlockParticleEmitter(Holder<ParticleType<?>> particleType, BlockContextExpression chance, BlockContextExpression count, BlockContextExpression x, BlockContextExpression y, BlockContextExpression z, BlockContextExpression dx, BlockContextExpression dy, BlockContextExpression dz, Optional<BlockContextExpression> r, Optional<BlockContextExpression> g, Optional<BlockContextExpression> b, Optional<BlockContextExpression> a, Optional<BlockContextExpression> roll, Optional<BlockContextExpression> size, Optional<BlockContextExpression> custom, RuleTest predicate, Optional<HolderSet<Biome>> biomes, SpawnLocation spawnLocation, TickSource spawnSource) implements BlockClientTickable
{
    public static final Codec<BlockParticleEmitter> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, BuiltInRegistries.PARTICLE_TYPE.holderByNameCodec().fieldOf("particle").forGetter(BlockParticleEmitter::particleType), BlockContextExpression.CODEC.optionalFieldOf("chance", (Object)BlockContextExpression.ONE).forGetter(BlockParticleEmitter::chance), BlockContextExpression.CODEC.optionalFieldOf("count", (Object)BlockContextExpression.ONE).forGetter(BlockParticleEmitter::count), BlockContextExpression.CODEC.optionalFieldOf("x", (Object)BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::x), BlockContextExpression.CODEC.optionalFieldOf("y", (Object)BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::y), BlockContextExpression.CODEC.optionalFieldOf("z", (Object)BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::z), BlockContextExpression.CODEC.optionalFieldOf("dx", (Object)BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dx), BlockContextExpression.CODEC.optionalFieldOf("dy", (Object)BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dy), BlockContextExpression.CODEC.optionalFieldOf("dz", (Object)BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dz), BlockContextExpression.CODEC.optionalFieldOf("red").forGetter(BlockParticleEmitter::r), BlockContextExpression.CODEC.optionalFieldOf("green").forGetter(BlockParticleEmitter::g), BlockContextExpression.CODEC.optionalFieldOf("blue").forGetter(BlockParticleEmitter::b), BlockContextExpression.CODEC.optionalFieldOf("alpha").forGetter(BlockParticleEmitter::a), BlockContextExpression.CODEC.optionalFieldOf("roll").forGetter(BlockParticleEmitter::roll), BlockContextExpression.CODEC.optionalFieldOf("size").forGetter(BlockParticleEmitter::size), BlockContextExpression.CODEC.optionalFieldOf("custom").forGetter(BlockParticleEmitter::custom), RuleTest.CODEC.optionalFieldOf("state_predicate", (Object)AlwaysTrueTest.INSTANCE).forGetter(BlockParticleEmitter::predicate), RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(BlockParticleEmitter::biomes), SpawnLocation.CODEC.optionalFieldOf("spawn_location", (Object)SpawnLocation.CENTER).forGetter(BlockParticleEmitter::spawnLocation), TickSource.CODEC.optionalFieldOf("tick_source", (Object)TickSource.ANIMATE_TICK).forGetter(BlockParticleEmitter::spawnSource)).apply(i, BlockParticleEmitter::new));

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, TickSource source) {
        if (source != this.spawnSource) {
            return;
        }
        double spawnChance = this.chance.getValue(level, pos, state);
        if ((double)level.random.nextFloat() < spawnChance && this.predicate().test(state, level.random)) {
            if (this.biomes.isPresent()) {
                Holder biome = level.getBiome(pos);
                if (!this.biomes.get().contains(biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(level, pos, state)) {
                CustomParticleType.setStateHack(state);
                ParticleOptions po = this.getParticleOptions(level, pos, state);
                if (po == null) {
                    return;
                }
                Vec3 pp = this.spawnLocation.getLocation(pos, state, level.random);
                level.addAlwaysVisibleParticle(po, pp.x() + this.x.getValue(level, pos, state), pp.y() + this.y.getValue(level, pos, state), pp.z() + this.z.getValue(level, pos, state), this.dx.getValue(level, pos, state), this.dy.getValue(level, pos, state), this.dz.getValue(level, pos, state));
                ++i;
            }
        }
    }

    @Nullable
    private ParticleOptions getParticleOptions(Level level, BlockPos pos, BlockState state) {
        SimpleParticleType po;
        ParticleType particleTypeValue = (ParticleType)this.particleType.value();
        if (Polytone.CUSTOM_PARTICLES.isDynamicParticle(((ResourceKey)this.particleType.unwrapKey().get()).location())) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            this.r.ifPresent(exp -> map.put("red", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.g.ifPresent(exp -> map.put("green", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.b.ifPresent(exp -> map.put("blue", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.a.ifPresent(exp -> map.put("alpha", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.roll.ifPresent(exp -> map.put("roll", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.size.ifPresent(exp -> map.put("size", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.custom.ifPresent(exp -> map.put("custom", Float.valueOf((float)exp.getValue(level, pos, state))));
            return new ExtraDataParticleOptions(map, particleTypeValue);
        }
        if (particleTypeValue instanceof SimpleParticleType) {
            SimpleParticleType st;
            po = st = (SimpleParticleType)particleTypeValue;
        } else if (particleTypeValue == ParticleTypes.BLOCK || particleTypeValue == ParticleTypes.FALLING_DUST || particleTypeValue == ParticleTypes.BLOCK_MARKER || particleTypeValue == ParticleTypes.DUST_PILLAR) {
            po = new BlockParticleOption(particleTypeValue, state);
        } else if (particleTypeValue == ParticleTypes.ITEM) {
            po = new ItemParticleOption(particleTypeValue, state.getBlock().asItem().getDefaultInstance());
        } else {
            Polytone.LOGGER.error("Unsupported particle type: {}", (Object)particleTypeValue);
            return null;
        }
        return po;
    }

    public static Vec3 getParticleSpawnPosOnFace(RandomSource random, BlockPos pos, Direction direction) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        int i = direction.getStepX();
        int j = direction.getStepY();
        int k = direction.getStepZ();
        double d0 = vec3.x + (i == 0 ? Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.y + (j == 0 ? Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.z + (k == 0 ? Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        return new Vec3(d0, d1, d2);
    }

    public static enum SpawnLocation implements StringRepresentable
    {
        CENTER,
        LOWER_CORNER,
        BLOCK_FACES;

        public static final Codec<SpawnLocation> CODEC;

        Vec3 getLocation(BlockPos pos, BlockState state, RandomSource rand) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> Vec3.atLowerCornerOf((Vec3i)pos);
                case 0 -> Vec3.atCenterOf((Vec3i)pos);
                case 2 -> {
                    Direction dir = Direction.values()[rand.nextInt(Direction.values().length)];
                    yield BlockParticleEmitter.getParticleSpawnPosOnFace(rand, pos, dir);
                }
            };
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(SpawnLocation::values);
        }
    }
}

