/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.slotify.GuiModifier;
import net.mehvahdjukaar.polytone.slotify.SpecialOffset;
import net.mehvahdjukaar.polytone.slotify.WidgetModifier;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import org.jetbrains.annotations.Nullable;

public record ScreenModifier(int titleX, int titleY, int labelX, int labelY, @Nullable Integer titleColor, @Nullable Integer labelColor, List<Renderable> extraRenderables, List<WidgetModifier> widgetModifiers, Map<String, SpecialOffset> specialOffsets) {
    public static ScreenModifier fromGuiMod(GuiModifier original) {
        ArrayList<Renderable> lis = new ArrayList<Renderable>(original.sprites());
        lis.addAll(original.textList());
        return new ScreenModifier(original.titleX(), original.titleY(), original.labelX(), original.labelY(), original.titleColor(), original.labelColor(), lis, new ArrayList<WidgetModifier>(original.widgetModifiers()), Map.copyOf(original.specialOffsets()));
    }

    public ScreenModifier merge(ScreenModifier newMod) {
        return new ScreenModifier(newMod.titleX != 0 ? newMod.titleX : this.titleX, newMod.titleY != 0 ? newMod.titleY : this.titleY, newMod.labelX != 0 ? newMod.labelX : this.labelX, newMod.labelY != 0 ? newMod.labelY : this.labelY, newMod.titleColor != null ? newMod.titleColor : this.titleColor, newMod.labelColor != null ? newMod.labelColor : this.labelColor, Utils.mergeList(newMod.extraRenderables, this.extraRenderables), Utils.mergeList(newMod.widgetModifiers, this.widgetModifiers), Utils.mergedMap(newMod.specialOffsets, this.specialOffsets));
    }

    @Nullable
    public SpecialOffset getSpecial(String key) {
        return this.specialOffsets.get(key);
    }

    public void modifyWidgets(AbstractWidget button) {
        for (WidgetModifier m : this.widgetModifiers) {
            m.maybeModify(button);
        }
    }

    public void renderExtrs(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        this.extraRenderables.forEach(r -> r.render(poseStack, mouseX, mouseY, partialTicks));
    }
}

