/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public record SimpleSprite(ResourceLocation texture, float x, float y, float width, float height, float z, Optional<String> tooltip) implements Renderable
{
    public static final Codec<SimpleSprite> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SimpleSprite::texture), (App)Codec.FLOAT.fieldOf("x").forGetter(SimpleSprite::x), (App)Codec.FLOAT.fieldOf("y").forGetter(SimpleSprite::y), (App)Codec.FLOAT.fieldOf("width").forGetter(SimpleSprite::width), (App)Codec.FLOAT.fieldOf("height").forGetter(SimpleSprite::height), (App)Codec.FLOAT.optionalFieldOf("z", (Object)Float.valueOf(0.0f)).forGetter(SimpleSprite::z), (App)Codec.STRING.optionalFieldOf("tooltip").forGetter(SimpleSprite::tooltip)).apply((Applicative)i, SimpleSprite::new));

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(this.texture);
        MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.guiTextured((ResourceLocation)sprite.atlasLocation()));
        SimpleSprite.blit(guiGraphics.pose().last().pose(), vertexConsumer, this.x, this.x + this.width, this.y, this.y + this.height, this.z, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), -1);
    }

    public static void blit(Matrix4f matrix, VertexConsumer vertexConsumer, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV, int color) {
        vertexConsumer.addVertex(matrix, x1, y1, blitOffset).setUv(minU, minV).setColor(color);
        vertexConsumer.addVertex(matrix, x1, y2, blitOffset).setUv(minU, maxV).setColor(color);
        vertexConsumer.addVertex(matrix, x2, y2, blitOffset).setUv(maxU, maxV).setColor(color);
        vertexConsumer.addVertex(matrix, x2, y1, blitOffset).setUv(maxU, minV).setColor(color);
    }
}

