/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.mehvahdjukaar.polytone.texture.DayTimeTexture;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteTicker;
import org.jetbrains.annotations.Nullable;

public class PolytoneTextureTicker
implements SpriteTicker {
    private final SpriteContents.AnimatedTexture animationInfo;
    @Nullable
    private final InterpolationData interpolationData;
    private final float animationScaleFactor;
    private final TreeMap<Float, Integer> frameMap = new TreeMap();
    private final int timeCycleDuration;
    private final DayTimeTexture.Mode mode;
    private int lastFrameIndex = 0;

    public PolytoneTextureTicker(SpriteContents.AnimatedTexture animationInfo, SpriteContents spriteContents, boolean interpolateFrames, int dayDuration, DayTimeTexture.Mode mode) {
        this.animationInfo = animationInfo;
        this.timeCycleDuration = dayDuration;
        this.mode = mode;
        this.interpolationData = interpolateFrames ? new InterpolationData(spriteContents) : null;
        int totalDuration = 0;
        for (SpriteContents.FrameInfo frameInfo : animationInfo.frames) {
            totalDuration += frameInfo.time;
        }
        this.animationScaleFactor = 1.0f / (float)totalDuration;
        float accumulatedTime = 0.0f;
        for (int i = 0; i < animationInfo.frames.size(); ++i) {
            SpriteContents.FrameInfo frameInfo = (SpriteContents.FrameInfo)animationInfo.frames.get(i);
            float scaledDuration = (float)frameInfo.time * this.animationScaleFactor;
            this.frameMap.put(Float.valueOf(accumulatedTime), i);
            accumulatedTime += scaledDuration;
        }
    }

    public void tickAndUpload(int x, int y) {
        Float delta = this.getDelta();
        if (delta == null) {
            return;
        }
        Map.Entry<Float, Integer> currentFrame = this.frameMap.floorEntry(delta);
        Integer frameOrdinal = currentFrame.getValue();
        List frames = this.animationInfo.frames;
        SpriteContents.FrameInfo frameInfo = (SpriteContents.FrameInfo)frames.get(frameOrdinal);
        if (frameInfo.index != this.lastFrameIndex) {
            this.animationInfo.uploadFrame(x, y, frameInfo.index);
        }
        if (this.interpolationData != null) {
            SpriteContents.FrameInfo nextFrameInfo = (SpriteContents.FrameInfo)frames.get((frameOrdinal + 1) % frames.size());
            float floorKey = currentFrame.getKey().floatValue();
            float frameDelta = (delta.floatValue() - floorKey) / this.animationScaleFactor;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.interpolationData.uploadInterpolatedFrame(x, y, frameInfo, nextFrameInfo, frameDelta, this.animationInfo));
            } else {
                this.interpolationData.uploadInterpolatedFrame(x, y, frameInfo, nextFrameInfo, frameDelta, this.animationInfo);
            }
        }
        this.lastFrameIndex = frameInfo.index;
    }

    @Nullable
    private Float getDelta() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        return switch (this.mode) {
            case DayTimeTexture.Mode.WEATHER -> {
                float rainAndThunder = ClientFrameTicker.getRainAndThunder() * 2.0f / 3.0f;
                yield Float.valueOf(rainAndThunder + 0.0f);
            }
            case DayTimeTexture.Mode.GAME_TIME -> {
                double gameTime = level.getGameTime() % (long)this.timeCycleDuration;
                yield Float.valueOf((float)(gameTime / (double)this.timeCycleDuration));
            }
            case DayTimeTexture.Mode.SCREEN_TIME -> Float.valueOf(Math.min(1.0f, ClientFrameTicker.getGuiTime() / (float)this.timeCycleDuration));
            default -> {
                double dayTime = ClientFrameTicker.getDayTime() % (double)this.timeCycleDuration;
                yield Float.valueOf((float)(dayTime / (double)this.timeCycleDuration));
            }
        };
    }

    public void close() {
        if (this.interpolationData != null) {
            this.interpolationData.close();
        }
    }

    public static final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] activeFrame;
        private final SpriteContents spriteContents;

        InterpolationData(SpriteContents spriteContents) {
            this.spriteContents = spriteContents;
            this.activeFrame = new NativeImage[spriteContents.byMipLevel.length];
            for (int i = 0; i < this.activeFrame.length; ++i) {
                int j = spriteContents.width() >> i;
                int k = spriteContents.height() >> i;
                this.activeFrame[i] = new NativeImage(j, k, false);
            }
        }

        void uploadInterpolatedFrame(int x, int y, SpriteContents.FrameInfo currentFrame, SpriteContents.FrameInfo nextFrame, float frameDelta, SpriteContents.AnimatedTexture animatedTexture) {
            double time = currentFrame.time;
            double delta = 1.0 - (double)frameDelta / time;
            int currentFrameIndex = currentFrame.index;
            int nextFrameIndex = nextFrame.index;
            if (currentFrameIndex != nextFrameIndex) {
                for (int k = 0; k < this.activeFrame.length; ++k) {
                    int l = this.spriteContents.width() >> k;
                    int m = this.spriteContents.height() >> k;
                    for (int n = 0; n < m; ++n) {
                        for (int o = 0; o < l; ++o) {
                            int p = this.getPixel(animatedTexture, currentFrameIndex, k, o, n);
                            int q = this.getPixel(animatedTexture, nextFrameIndex, k, o, n);
                            int r = this.mix(delta, p >> 16 & 0xFF, q >> 16 & 0xFF);
                            int s = this.mix(delta, p >> 8 & 0xFF, q >> 8 & 0xFF);
                            int t = this.mix(delta, p & 0xFF, q & 0xFF);
                            this.activeFrame[k].setPixel(o, n, p & 0xFF000000 | r << 16 | s << 8 | t);
                        }
                    }
                }
                this.spriteContents.upload(x, y, 0, 0, this.activeFrame);
            }
        }

        private int getPixel(SpriteContents.AnimatedTexture animatedTexture, int frameIndex, int mipLevel, int x, int y) {
            return this.spriteContents.byMipLevel[mipLevel].getPixel(x + (animatedTexture.getFrameX(frameIndex) * this.spriteContents.width() >> mipLevel), y + (animatedTexture.getFrameY(frameIndex) * this.spriteContents.height() >> mipLevel));
        }

        private int mix(double delta, int color1, int color2) {
            return (int)(delta * (double)color1 + (1.0 - delta) * (double)color2);
        }

        @Override
        public void close() {
            for (NativeImage nativeImage : this.activeFrame) {
                nativeImage.close();
            }
        }
    }
}

