/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.Weather;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    private static final FogState ONE = new FogState(1.0f, 1.0f);
    private static final FogStateMutable lastBiomeFog = new FogStateMutable();
    private static final FogStateMutable lastLiquidFog = new FogStateMutable();

    @Nullable
    public static FogState modifyBiomeFog(float originalNearPlane, float originalFarPlane) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return null;
        }
        Level level = player.level();
        if (FogRenderer.getPriorityFogFunction((Entity)player, (float)mc.getDeltaTracker().getGameTimeDeltaPartialTick(false)) != null) {
            return null;
        }
        Holder biome = level.getBiome(player.blockPosition());
        BiomeEffectModifier fogMod = Polytone.BIOME_MODIFIERS.getFogModifier((Biome)biome.value());
        FogParam fogRadius = null;
        FogParam fogFade = null;
        if (fogMod != null) {
            fogRadius = fogMod.fogRadius().orElse(null);
            fogFade = fogMod.fogFade().orElse(null);
        }
        return FogManager.modifyFogParameters(level, originalNearPlane, originalFarPlane, fogRadius, fogFade, lastBiomeFog);
    }

    @Nullable
    public static FogState modifyFluidFog(float originalNearPlane, float originalFarPlane, @Nullable FogParam fogRadius, @Nullable FogParam fogFade) {
        return FogManager.modifyFogParameters((Level)Minecraft.getInstance().level, originalNearPlane, originalFarPlane, fogRadius, fogFade, lastLiquidFog);
    }

    @Nullable
    private static FogState modifyFogParameters(@Nullable Level level, float originalNearPlane, float originalFarPlane, @Nullable FogParam fogRadius, @Nullable FogParam fogFade, FogStateMutable old) {
        if (level == null) {
            return null;
        }
        Float radiusMult = null;
        Float fadeMul = null;
        if (fogRadius != null || fogFade != null) {
            radiusMult = Float.valueOf(fogRadius != null ? fogRadius.get(level) : 1.0f);
            fadeMul = Float.valueOf(fogFade != null ? fogFade.get(level) : 1.0f);
        }
        if (radiusMult == null && (Mth.abs((float)(old.distanceMult - 1.0f)) > 0.02f || Mth.abs((float)(old.endMult - 1.0f)) > 0.02f)) {
            radiusMult = Float.valueOf(1.0f);
            fadeMul = Float.valueOf(1.0f);
        }
        if (radiusMult != null) {
            float deltaTime = ClientFrameTicker.getDeltaTime();
            float interpolationFactor = deltaTime * 0.1f;
            old.distanceMult = Mth.lerp((float)interpolationFactor, (float)old.distanceMult, (float)fadeMul.floatValue());
            old.endMult = Mth.lerp((float)interpolationFactor, (float)old.endMult, (float)radiusMult.floatValue());
            float distance = originalFarPlane - originalNearPlane;
            return new FogState((originalFarPlane - distance * old.distanceMult) * old.endMult, originalFarPlane * old.endMult);
        }
        return null;
    }

    public static interface FogParam {
        public static final Codec<FogParam> SIMPLE_CODEC = Codec.FLOAT.xmap(f -> l -> f.floatValue(), fogParam -> Float.valueOf(fogParam.get(null)));
        public static final Codec<FogParam> CODEC = Codec.withAlternative((Codec)Codec.withAlternative(SIMPLE_CODEC, (Codec)Codec.simpleMap(Weather.CODEC, SIMPLE_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])Weather.values())).xmap(FogMap::new, FogMap::map).codec()), (Codec)BlockContextExpression.CODEC.xmap(FogExpression::new, fogMap -> fogMap.map));

        public float get(Level var1);
    }

    private static class FogStateMutable {
        private float distanceMult = 1.0f;
        private float endMult = 1.0f;

        private FogStateMutable() {
        }
    }

    public record FogState(float start, float end) {
    }

    public record FogMap(Map<Weather, FogParam> map) implements FogParam
    {
        @Override
        public float get(Level level) {
            Weather w = Weather.get(level);
            return this.map.getOrDefault((Object)w, l -> 1.0f).get(level);
        }
    }

    public record FogExpression(BlockContextExpression map) implements FogParam
    {
        @Override
        public float get(Level level) {
            BlockPos pos = ClientFrameTicker.getCameraPos();
            return (float)this.map.getValue(level, pos, Blocks.AIR.defaultBlockState());
        }
    }
}

