/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.resources.ResourceLocation;

public record RemappingCodec<A, B>(MapRegistry<A> from, MapRegistry<B> to, Function<A, B> remap) implements Codec<B>
{
    public <T> DataResult<Pair<B, T>> decode(DynamicOps<T> ops, T input) {
        return ResourceLocation.CODEC.decode(ops, input).flatMap(pair -> {
            B remapped;
            ResourceLocation id = (ResourceLocation)pair.getFirst();
            A colorGetter = this.from.getValue((ResourceLocation)pair.getFirst());
            if (colorGetter == null) {
                DataResult.error(() -> "Could not find any entry with key '" + String.valueOf(id) + "' in registry [" + this.from.getName() + "] \n Known keys: " + String.valueOf(this.from.keySet()));
            }
            if (!this.to.containsKey(id)) {
                remapped = this.remap.apply(colorGetter);
                this.to.register(id, remapped);
            } else {
                remapped = this.to.getValue(id);
            }
            return DataResult.success((Object)Pair.of(remapped, (Object)pair.getSecond()));
        });
    }

    public <T> DataResult<T> encode(B input, DynamicOps<T> ops, T prefix) {
        ResourceLocation id = this.to.getKey(input);
        if (id == null) {
            return DataResult.error(() -> "Could not find any entry with value '" + String.valueOf(input) + "' in registry [" + this.to.getName() + "] \n Known values: " + String.valueOf(this.to.getValues()));
        }
        return ResourceLocation.CODEC.encode((Object)id, ops, prefix);
    }
}

