/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils.neoforge;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.function.Consumer;
import net.mehvahdjukaar.polytone.utils.BakedQuadBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class BakedQuadBuilderImpl
implements BakedQuadBuilder {
    private final QuadBakingVertexConsumer inner;
    private final TextureAtlasSprite sprite;
    private final Matrix4f globalTransform;
    private final Matrix3f normalTransf;
    private int emissivity = 0;
    private BakedQuad output;
    private boolean autoDirection = false;
    private Consumer<BakedQuad> quadConsumer = s -> {
        this.output = s;
    };
    private int vertexIndex = 0;

    public static BakedQuadBuilder create(TextureAtlasSprite sprite, @Nullable Matrix4f transformation) {
        return new BakedQuadBuilderImpl(sprite, transformation);
    }

    private BakedQuadBuilderImpl(TextureAtlasSprite sprite, @Nullable Matrix4f transformation) {
        this.inner = new QuadBakingVertexConsumer();
        this.globalTransform = transformation;
        this.sprite = sprite;
        this.inner.setShade(true);
        this.inner.setHasAmbientOcclusion(true);
        this.inner.setSprite(sprite);
        this.normalTransf = transformation == null ? null : new Matrix3f((Matrix4fc)transformation).invert().transpose();
    }

    @Override
    public BakedQuad build() {
        Preconditions.checkNotNull((Object)this.output, (Object)"vertex data has not been fully filled");
        if (this.emissivity != 0) {
            QuadTransformers.settingEmissivity((int)this.emissivity).processInPlace(this.output);
        }
        return this.output;
    }

    @Override
    public BakedQuadBuilderImpl setAutoBuild(Consumer<BakedQuad> quadConsumer) {
        this.quadConsumer = quadConsumer;
        return this;
    }

    public BakedQuadBuilderImpl addVertex(float x, float y, float z) {
        ++this.vertexIndex;
        if (this.vertexIndex == 4) {
            this.vertexIndex = 0;
            if (this.quadConsumer != null) {
                this.quadConsumer.accept(this.inner.bakeQuad());
            }
        }
        if (this.globalTransform != null) {
            this.inner.addVertex(new Matrix4f((Matrix4fc)this.globalTransform), x, y, z);
        } else {
            this.inner.addVertex(x, y, z);
        }
        return this;
    }

    public BakedQuadBuilderImpl setColor(int red, int green, int blue, int alpha) {
        this.inner.setColor(red, green, blue, alpha);
        return this;
    }

    public BakedQuadBuilderImpl setUv(float u, float v) {
        this.inner.setUv(this.sprite.getU(u * 16.0f), this.sprite.getV(v * 16.0f));
        return this;
    }

    public VertexConsumer setUv1(int i, int j) {
        this.inner.setUv1(i, j);
        return this;
    }

    public BakedQuadBuilderImpl setOverlay(int ov) {
        this.inner.setOverlay(ov);
        return this;
    }

    public BakedQuadBuilderImpl setUv2(int u, int v) {
        this.inner.setUv2(u, v);
        return this;
    }

    public BakedQuadBuilderImpl setNormal(float x, float y, float z) {
        if (this.globalTransform != null) {
            Vector3f normal = this.normalTransf.transform(new Vector3f(x, y, z));
            normal.normalize();
            this.inner.setNormal(normal.x, normal.y, normal.z);
        } else {
            this.inner.setNormal(x, y, z);
        }
        if (this.autoDirection) {
            this.setDirection(Direction.getApproximateNearest((float)x, (float)y, (float)z));
        }
        return this;
    }

    @Override
    public BakedQuadBuilder setDirection(Direction direction) {
        if (this.globalTransform != null) {
            direction = Direction.rotate((Matrix4f)this.globalTransform, (Direction)direction);
        }
        this.inner.setDirection(direction);
        return this;
    }

    @Override
    public BakedQuadBuilder setAmbientOcclusion(boolean ambientOcclusion) {
        this.inner.setHasAmbientOcclusion(ambientOcclusion);
        return this;
    }

    @Override
    public BakedQuadBuilder setTint(int tintIndex) {
        this.inner.setTintIndex(tintIndex);
        return this;
    }

    @Override
    public BakedQuadBuilder setShade(boolean shade) {
        this.inner.setShade(shade);
        return this;
    }

    @Override
    public BakedQuadBuilder lightEmission(int light) {
        this.emissivity = light;
        return this;
    }

    @Override
    public BakedQuadBuilder fromVanilla(BakedQuad q) {
        int[] v = Arrays.copyOf(q.getVertices(), q.getVertices().length);
        this.output = new BakedQuad(v, q.getTintIndex(), q.getDirection(), q.getSprite(), q.isShade(), q.getLightEmission(), q.hasAmbientOcclusion());
        return this;
    }

    @Override
    public BakedQuadBuilder setAutoDirection() {
        this.autoDirection = true;
        return this;
    }
}

