/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.particle.ExtraDataParticleOptions;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.codec.BiggerCodecs;
import net.mehvahdjukaar.polytone.utils.codec.CodecUtils;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3818;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record BlockParticleEmitter(Optional<class_6880<class_2396<?>>> particleType, BlockContextExpression chance, BlockContextExpression count, BlockContextExpression x, BlockContextExpression y, BlockContextExpression z, BlockContextExpression dx, BlockContextExpression dy, BlockContextExpression dz, Optional<BlockContextExpression> r, Optional<BlockContextExpression> g, Optional<BlockContextExpression> b, Optional<BlockContextExpression> a, Optional<BlockContextExpression> roll, Optional<BlockContextExpression> size, Optional<BlockContextExpression> custom, class_3825 predicate, Optional<class_6885<class_1959>> biomes, SpawnLocation spawnLocation) implements BlockClientTickable
{
    public static final Codec<BlockParticleEmitter> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, CodecUtils.forwardAwareHolderByNameCodec(class_7923.field_41180).fieldOf("particle").forGetter(BlockParticleEmitter::particleType), StrOpt.of(BlockContextExpression.CODEC, "chance", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::chance), StrOpt.of(BlockContextExpression.CODEC, "count", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::count), StrOpt.of(BlockContextExpression.CODEC, "x", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::x), StrOpt.of(BlockContextExpression.CODEC, "y", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::y), StrOpt.of(BlockContextExpression.CODEC, "z", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::z), StrOpt.of(BlockContextExpression.CODEC, "dx", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dx), StrOpt.of(BlockContextExpression.CODEC, "dy", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dy), StrOpt.of(BlockContextExpression.CODEC, "dz", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dz), BlockContextExpression.CODEC.optionalFieldOf("red").forGetter(BlockParticleEmitter::r), BlockContextExpression.CODEC.optionalFieldOf("green").forGetter(BlockParticleEmitter::g), BlockContextExpression.CODEC.optionalFieldOf("blue").forGetter(BlockParticleEmitter::b), BlockContextExpression.CODEC.optionalFieldOf("alpha").forGetter(BlockParticleEmitter::a), BlockContextExpression.CODEC.optionalFieldOf("roll").forGetter(BlockParticleEmitter::roll), BlockContextExpression.CODEC.optionalFieldOf("size").forGetter(BlockParticleEmitter::size), BlockContextExpression.CODEC.optionalFieldOf("custom").forGetter(BlockParticleEmitter::custom), CodecUtils.lenientWithLog(class_3825.field_25012, "state_predicate", class_3818.field_16868).forGetter(BlockParticleEmitter::predicate), CodecUtils.forwardAwareHomogeneousList(class_7924.field_41236).optionalFieldOf("biomes").forGetter(BlockParticleEmitter::biomes), StrOpt.of(SpawnLocation.CODEC, "spawn_location", SpawnLocation.CENTER).forGetter(BlockParticleEmitter::spawnLocation)).apply(i, BlockParticleEmitter::new));

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.particleType.isEmpty()) {
            return;
        }
        double spawnChance = this.chance.getValue(level, pos, state);
        if ((double)level.field_9229.method_43057() < spawnChance && this.predicate().method_16768(state, level.field_9229)) {
            if (this.biomes.isPresent()) {
                class_6880 biome = level.method_23753(pos);
                if (!this.biomes.get().method_40241(biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(level, pos, state)) {
                CustomParticleType.setStateHack(state);
                class_2394 po = this.getParticleOptions(level, pos, state);
                if (po == null) {
                    return;
                }
                class_243 pp = this.spawnLocation.getLocation(pos, state, level.field_9229);
                level.method_8406(po, pp.method_10216() + this.x.getValue(level, pos, state), pp.method_10214() + this.y.getValue(level, pos, state), pp.method_10215() + this.z.getValue(level, pos, state), this.dx.getValue(level, pos, state), this.dy.getValue(level, pos, state), this.dz.getValue(level, pos, state));
                ++i;
            }
        }
    }

    @Nullable
    private class_2394 getParticleOptions(class_1937 level, class_2338 pos, class_2680 state) {
        class_2400 po;
        class_2396 particleTypeValue = (class_2396)this.particleType.get().comp_349();
        if (Polytone.CUSTOM_PARTICLES.isDynamicParticle(((class_5321)this.particleType.get().method_40230().get()).method_29177())) {
            HashMap<String, Float> map = new HashMap<String, Float>();
            this.r.ifPresent(exp -> map.put("red", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.g.ifPresent(exp -> map.put("green", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.b.ifPresent(exp -> map.put("blue", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.a.ifPresent(exp -> map.put("alpha", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.roll.ifPresent(exp -> map.put("roll", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.size.ifPresent(exp -> map.put("size", Float.valueOf((float)exp.getValue(level, pos, state))));
            this.custom.ifPresent(exp -> map.put("custom", Float.valueOf((float)exp.getValue(level, pos, state))));
            return new ExtraDataParticleOptions(map, particleTypeValue);
        }
        if (particleTypeValue instanceof class_2400) {
            class_2400 st;
            po = st = (class_2400)particleTypeValue;
        } else if (particleTypeValue == class_2398.field_11217 || particleTypeValue == class_2398.field_11206 || particleTypeValue == class_2398.field_35434 || particleTypeValue == class_2398.field_11212) {
            po = new class_2388(particleTypeValue, state);
        } else if (particleTypeValue == class_2398.field_11218) {
            po = new class_2392(particleTypeValue, state.method_26204().method_8389().method_7854());
        } else {
            Polytone.LOGGER.error("Unsupported particle type: {}", (Object)particleTypeValue);
            return null;
        }
        return po;
    }

    public static class_243 getParticleSpawnPosOnFace(class_5819 random, class_2338 pos, class_2350 direction) {
        class_243 vec3 = class_243.method_24953((class_2382)pos);
        int i = direction.method_10148();
        int j = direction.method_10164();
        int k = direction.method_10165();
        double d0 = vec3.field_1352 + (i == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.field_1351 + (j == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.field_1350 + (k == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        return new class_243(d0, d1, d2);
    }

    public static enum SpawnLocation {
        CENTER,
        LOWER_CORNER,
        BLOCK_FACES;

        public static final Codec<SpawnLocation> CODEC;

        class_243 getLocation(class_2338 pos, class_2680 state, class_5819 rand) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> class_243.method_24954((class_2382)pos);
                case 0 -> class_243.method_24953((class_2382)pos);
                case 2 -> {
                    class_2350 dir = class_2350.values()[rand.method_43048(class_2350.values().length)];
                    yield BlockParticleEmitter.getParticleSpawnPosOnFace(rand, pos, dir);
                }
            };
        }

        static {
            CODEC = Codec.STRING.xmap(s -> SpawnLocation.valueOf(s.toUpperCase(Locale.ROOT)), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }
}

