/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.collect.LinkedListMultimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsModifier;
import net.mehvahdjukaar.polytone.dimension.DimensionTarget;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.BiomeKeysCache;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2457;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class LegacyHelper {
    private static final Map<String, String> PATHS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), m -> {
        m.put((Object)"world0", (Object)"overworld");
        m.put((Object)"world0_thunder", (Object)"overworld_thunder");
        m.put((Object)"world0_rain", (Object)"overworld_rain");
        m.put((Object)"world1", (Object)"the_end");
        m.put((Object)"world-1", (Object)"the_nether");
        m.put((Object)"pine", (Object)"spruce_leaves");
        m.put((Object)"birch", (Object)"birch_leaves");
        m.put((Object)"redstone", (Object)"redstone_wire");
        m.put((Object)"pumpkinstem", (Object)"pumpkin_stem");
        m.put((Object)"melonstem", (Object)"melon_stem");
        m.put((Object)"underwater", (Object)"water_fog");
    });
    public static final Decoder<BlockPropertyModifier> OF_JSON_CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(Codec.STRING, "format", "").forGetter(c -> ""), (App)StrOpt.of(Codec.STRING.listOf(), "blocks", List.of()).forGetter(c -> List.of()), (App)StrOpt.of(ColorUtils.CODEC, "color").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING.xmap(Integer::parseInt, String::valueOf), "yVariance").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING.xmap(Integer::parseInt, String::valueOf), "yoffset").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING, "source").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.BOOL, "force_tint", true).forGetter(c -> true)).apply((Applicative)i, LegacyHelper::decodeOFPropertyJson));
    private static final Object2IntMap<class_5321<class_1959>> BIOME_ID_MAP = (Object2IntMap)class_156.method_656(() -> {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        map.put(LegacyHelper.biomeResKey("the_void"), 0);
        map.put(LegacyHelper.biomeResKey("plains"), 1);
        map.put(LegacyHelper.biomeResKey("sunflower_plains"), 2);
        map.put(LegacyHelper.biomeResKey("snowy_plains"), 3);
        map.put(LegacyHelper.biomeResKey("ice_spikes"), 4);
        map.put(LegacyHelper.biomeResKey("desert"), 5);
        map.put(LegacyHelper.biomeResKey("swamp"), 6);
        map.put(LegacyHelper.biomeResKey("mangrove_swamp"), 7);
        map.put(LegacyHelper.biomeResKey("forest"), 8);
        map.put(LegacyHelper.biomeResKey("flower_forest"), 9);
        map.put(LegacyHelper.biomeResKey("birch_forest"), 10);
        map.put(LegacyHelper.biomeResKey("dark_forest"), 11);
        map.put(LegacyHelper.biomeResKey("old_growth_birch_forest"), 12);
        map.put(LegacyHelper.biomeResKey("old_growth_pine_taiga"), 13);
        map.put(LegacyHelper.biomeResKey("old_growth_spruce_taiga"), 14);
        map.put(LegacyHelper.biomeResKey("taiga"), 15);
        map.put(LegacyHelper.biomeResKey("snowy_taiga"), 16);
        map.put(LegacyHelper.biomeResKey("savanna"), 17);
        map.put(LegacyHelper.biomeResKey("savanna_plateau"), 18);
        map.put(LegacyHelper.biomeResKey("windswept_hills"), 19);
        map.put(LegacyHelper.biomeResKey("windswept_gravelly_hills"), 20);
        map.put(LegacyHelper.biomeResKey("windswept_forest"), 21);
        map.put(LegacyHelper.biomeResKey("windswept_savanna"), 22);
        map.put(LegacyHelper.biomeResKey("jungle"), 23);
        map.put(LegacyHelper.biomeResKey("sparse_jungle"), 24);
        map.put(LegacyHelper.biomeResKey("bamboo_jungle"), 25);
        map.put(LegacyHelper.biomeResKey("badlands"), 26);
        map.put(LegacyHelper.biomeResKey("eroded_badlands"), 27);
        map.put(LegacyHelper.biomeResKey("wooded_badlands"), 28);
        map.put(LegacyHelper.biomeResKey("meadow"), 29);
        map.put(LegacyHelper.biomeResKey("cherry_grove"), 30);
        map.put(LegacyHelper.biomeResKey("grove"), 31);
        map.put(LegacyHelper.biomeResKey("snowy_slopes"), 32);
        map.put(LegacyHelper.biomeResKey("frozen_peaks"), 33);
        map.put(LegacyHelper.biomeResKey("jagged_peaks"), 34);
        map.put(LegacyHelper.biomeResKey("stony_peaks"), 35);
        map.put(LegacyHelper.biomeResKey("river"), 36);
        map.put(LegacyHelper.biomeResKey("frozen_river"), 37);
        map.put(LegacyHelper.biomeResKey("beach"), 38);
        map.put(LegacyHelper.biomeResKey("snowy_beach"), 39);
        map.put(LegacyHelper.biomeResKey("stony_shore"), 40);
        map.put(LegacyHelper.biomeResKey("warm_ocean"), 41);
        map.put(LegacyHelper.biomeResKey("lukewarm_ocean"), 42);
        map.put(LegacyHelper.biomeResKey("deep_lukewarm_ocean"), 43);
        map.put(LegacyHelper.biomeResKey("ocean"), 44);
        map.put(LegacyHelper.biomeResKey("deep_ocean"), 45);
        map.put(LegacyHelper.biomeResKey("cold_ocean"), 46);
        map.put(LegacyHelper.biomeResKey("deep_cold_ocean"), 47);
        map.put(LegacyHelper.biomeResKey("frozen_ocean"), 48);
        map.put(LegacyHelper.biomeResKey("deep_frozen_ocean"), 49);
        map.put(LegacyHelper.biomeResKey("mushroom_fields"), 50);
        map.put(LegacyHelper.biomeResKey("dripstone_caves"), 51);
        map.put(LegacyHelper.biomeResKey("lush_caves"), 52);
        map.put(LegacyHelper.biomeResKey("deep_dark"), 53);
        map.put(LegacyHelper.biomeResKey("nether_wastes"), 54);
        map.put(LegacyHelper.biomeResKey("warped_forest"), 55);
        map.put(LegacyHelper.biomeResKey("crimson_forest"), 56);
        map.put(LegacyHelper.biomeResKey("soul_sand_valley"), 57);
        map.put(LegacyHelper.biomeResKey("basalt_deltas"), 58);
        map.put(LegacyHelper.biomeResKey("the_end"), 59);
        map.put(LegacyHelper.biomeResKey("end_highlands"), 60);
        map.put(LegacyHelper.biomeResKey("end_midlands"), 61);
        map.put(LegacyHelper.biomeResKey("small_end_islands"), 62);
        map.put(LegacyHelper.biomeResKey("end_barrens"), 63);
        map.put(LegacyHelper.biomeResKey("pale_garden"), 64);
        return map;
    });

    public static <T> Map<class_2960, T> convertPaths(Map<class_2960, T> map) {
        HashMap<class_2960, T> toUpdate = new HashMap<class_2960, T>();
        ArrayList<class_2960> toRemove = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, T> entry : map.entrySet()) {
            class_2960 id = entry.getKey();
            class_2960 newPath = LegacyHelper.convertPath(id);
            if (newPath.equals((Object)id)) continue;
            toUpdate.put(newPath, entry.getValue());
            toRemove.add(id);
        }
        toRemove.forEach(map.keySet()::remove);
        map.putAll(toUpdate);
        return map;
    }

    public static class_2960 convertPath(class_2960 id) {
        String path = PATHS.get(id.method_12832());
        return path == null ? id : id.method_45136(path);
    }

    public static Map<class_2960, Parsed<BlockPropertyModifier>> convertBlockProperties(Map<class_2960, Properties> ofProperties, Map<class_2960, ArrayImage> textures) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        ids.addAll(ofProperties.keySet());
        ids.addAll(textures.keySet());
        HashMap<class_2960, Parsed<BlockPropertyModifier>> map = new HashMap<class_2960, Parsed<BlockPropertyModifier>>();
        for (class_2960 id : ids) {
            Colormap colormap;
            @Nullable Properties prop = ofProperties.get(id);
            String path = id.method_12832();
            if (path.equals("stem") || path.equals("melon_stem") || path.equals("pumpkin_stem")) {
                colormap = Colormap.simple((state, level, pos, m, i) -> state != null && state.method_28498((class_2769)class_2513.field_11584) ? (float)((Integer)state.method_11654((class_2769)class_2513.field_11584)).intValue() / 7.0f : 0.0f, IColormapNumberProvider.ZERO);
                ArrayList<class_2248> targets = new ArrayList<class_2248>();
                if (!path.contains("melon")) {
                    targets.add(class_2246.field_9984);
                    targets.add(class_2246.field_10331);
                }
                if (!path.contains("pumpkin")) {
                    targets.add(class_2246.field_10168);
                    targets.add(class_2246.field_10150);
                }
                map.put(id, LegacyHelper.withCond(id, prop, BlockPropertyModifier.coloringBlocks((class_322)colormap, targets)));
                continue;
            }
            if (path.equals("redstone_wire")) {
                colormap = Colormap.simple(new IColormapNumberProvider(){

                    @Override
                    public float getValue(class_2680 state, class_2338 pos, class_1959 biome, BiomeIdMapper mapper, class_1799 stack) {
                        return state != null ? 1.0f - (float)((Integer)state.method_11654((class_2769)class_2457.field_11432)).intValue() / 15.0f : 1.0f;
                    }

                    @Override
                    public boolean usesBiome() {
                        return false;
                    }

                    @Override
                    public boolean usesPos() {
                        return false;
                    }
                }, IColormapNumberProvider.ZERO);
                map.put(id, LegacyHelper.withCond(id, prop, BlockPropertyModifier.coloringBlocks((class_322)colormap, class_2246.field_10091)));
                continue;
            }
            if (prop == null) continue;
            try {
                BlockPropertyModifier modifier = LegacyHelper.convertOFProperty(prop, id);
                map.put(id, LegacyHelper.withCond(id, prop, modifier));
            }
            catch (Exception e) {
                Polytone.LOGGER.error("FAILED TO CONVERT OPTIFINE COLORMAP AT {}. Its likely the file has errors: ", (Object)id, (Object)e);
            }
        }
        return map;
    }

    private static <T> Parsed<T> withCond(class_2960 id, @Nullable Properties prop, T t) {
        return Parsed.lowPriority(t, id, prop == null || LegacyHelper.checkConditions(prop));
    }

    private static boolean checkConditions(Properties prop) {
        boolean ignored = prop.getOrDefault((Object)"polytone_ignore", (Object)false).equals("true");
        if (ignored) {
            return false;
        }
        List<String> requireMods = List.of(prop.getProperty("require_mods", "").split(" "));
        for (String s : requireMods) {
            if (s.isEmpty() || PlatStuff.isModLoaded(s)) continue;
            return false;
        }
        return true;
    }

    private static BlockPropertyModifier decodeOFPropertyJson(String format, List<String> targets, Optional<Integer> singleColor, Optional<Integer> yVariance, Optional<Integer> yoffset, Optional<String> sourceTexture, boolean forceTint) {
        Set<Object> set = new HashSet();
        if (!targets.isEmpty()) {
            set = targets.stream().filter(s -> {
                try {
                    int iHateOptishit = Integer.parseInt(s);
                    return false;
                }
                catch (Exception exception) {
                    return true;
                }
            }).map(class_2960::new).collect(Collectors.toSet());
            if (forceTint) {
                set.forEach(LegacyHelper::forceBlockToHaveTintIndex);
            }
        }
        Integer col = singleColor.orElse(null);
        Colormap colormap = "fixed".equals(format) ? Colormap.createFixed() : ("grid".equals(format) ? Colormap.createBiomeId() : Colormap.createDefTriangle());
        if (col != null) {
            int[][] matrix = new int[][]{{col}};
            colormap.acceptTexture(new ArrayImage(matrix));
        } else if (sourceTexture.isPresent()) {
            class_2960 id = new class_2960("none");
            String source = sourceTexture.get().replace("~/colormap/", id.method_12836() + ":");
            if (source.contains("./")) {
                String path = id.method_12832();
                int index = path.lastIndexOf(47);
                String directoryPath = index == -1 ? "" : path.substring(0, index + 1);
                source = source.replace("./", id.method_12836() + ":" + directoryPath);
            }
            colormap.setExplicitTargetTexture(new class_2960(source));
        }
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, Targets.ofIds(set), false);
    }

    public static BlockPropertyModifier convertOFProperty(Properties properties, class_2960 id) {
        Set<Object> set;
        boolean forceTint = Boolean.parseBoolean(properties.getProperty("force_tint", "true"));
        String targets = properties.getProperty("blocks");
        if (targets != null) {
            set = Arrays.stream(targets.split(" ")).filter(s -> {
                try {
                    int iHateOptishit = Integer.parseInt(s);
                    return false;
                }
                catch (Exception exception) {
                    return true;
                }
            }).map(class_2960::new).collect(Collectors.toSet());
            if (forceTint) {
                set.forEach(LegacyHelper::forceBlockToHaveTintIndex);
            }
        } else {
            set = Set.of();
        }
        String format = properties.getProperty("format");
        Integer col = null;
        String singleColor = properties.getProperty("color");
        if (singleColor != null) {
            col = Integer.parseInt(singleColor, 16);
        }
        Colormap colormap = "fixed".equals(format) ? Colormap.createFixed() : ("grid".equals(format) ? Colormap.createBiomeId() : Colormap.createDefTriangle());
        if (col != null) {
            int[][] matrix = new int[][]{{col}};
            colormap.acceptTexture(new ArrayImage(matrix));
        } else {
            Object source = properties.getProperty("source");
            if (source != null) {
                if (((String)source).contains("~")) {
                    source = ((String)source).replace("~/colormap/", id.method_12836() + ":");
                } else {
                    String path = id.method_12832();
                    int index = path.lastIndexOf(47);
                    String directoryPath = index == -1 ? "" : path.substring(0, index + 1);
                    source = id.method_12836() + ":" + directoryPath + ((String)source).replace("./", "");
                }
                colormap.setExplicitTargetTexture(new class_2960((String)source));
            }
        }
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, Targets.ofOptionalIds(set), false);
    }

    public static Map<class_2960, Parsed<BlockPropertyModifier>> convertInlinedPalettes(Map<class_2960, String> inlineColormaps) {
        HashMap<class_2960, Parsed<BlockPropertyModifier>> map = new HashMap<class_2960, Parsed<BlockPropertyModifier>>();
        int k = 0;
        for (Map.Entry<class_2960, String> special : inlineColormaps.entrySet()) {
            class_2960 texturePath = special.getKey();
            Colormap colormap = Colormap.createDefTriangle();
            colormap.setExplicitTargetTexture(texturePath);
            HashSet<class_2960> blockTargets = new HashSet<class_2960>();
            for (String name : special.getValue().split(" ")) {
                if (name.isEmpty()) continue;
                class_2960 blockId = class_2960.method_12829((String)name);
                blockTargets.add(blockId);
                LegacyHelper.forceBlockToHaveTintIndex(blockId);
            }
            if (blockTargets.isEmpty()) continue;
            BlockPropertyModifier mod = BlockPropertyModifier.coloringBlocks((class_322)colormap, blockTargets);
            class_2960 id = texturePath.method_48331("-color_prop_palette_" + k++);
            map.put(id, Parsed.success(mod, id));
        }
        return map;
    }

    private static void forceBlockToHaveTintIndex(class_2960 blockId) {
        class_2248 block;
        Optional b = class_7923.field_41175.method_17966(blockId);
        if (b.isPresent() && (block = (class_2248)b.get()) != class_2246.field_10091 && block != class_2246.field_9984 && block != class_2246.field_10168) {
            Polytone.VARIANT_TEXTURES.addTintOverrideHack(block);
        }
    }

    public static int getBiomeId(class_1959 biome) {
        return BIOME_ID_MAP.getOrDefault(BiomeKeysCache.get(biome), 0);
    }

    private static class_5321<class_1959> biomeResKey(String endBarrens) {
        return class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960(endBarrens));
    }

    public static void convertOfBlockToFluidProp(LinkedListMultimap<class_2960, Parsed<BlockPropertyModifier>> parsedModifiers, Map<class_2960, ArrayImage> textures) {
        Parsed parsed;
        class_2960 id;
        HashMap<class_2960, Parsed> fluid = new HashMap<class_2960, Parsed>();
        HashMap<class_2960, Parsed> fog = new HashMap<class_2960, Parsed>();
        HashMap<class_2960, ArrayImage> filteredTextures = new HashMap<class_2960, ArrayImage>();
        for (Map.Entry entry : parsedModifiers.entries()) {
            id = (class_2960)entry.getKey();
            parsed = (Parsed)entry.getValue();
            BlockPropertyModifier modifier = (BlockPropertyModifier)parsed.getResultOrPartial();
            IColorGetter colormap = modifier.getColormap();
            if (!(colormap instanceof Colormap)) continue;
            Colormap c = (Colormap)colormap;
            String path = id.method_12832();
            if (!path.contains("water") && !path.contains("lava")) continue;
            if (path.endsWith("_fog") || path.contains("under")) {
                fog.put(id, parsed);
            } else {
                fluid.put(id, parsed);
            }
            class_2960 targetTexture = c.getTargetTexture(id);
            c.setExplicitTargetTexture(LegacyHelper.convertPath(targetTexture));
            if (!textures.containsKey(targetTexture)) continue;
            filteredTextures.put(targetTexture, textures.get(targetTexture));
        }
        for (Map.Entry entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            if (!id.method_12836().equals("minecraft") || !id.method_12832().contains("water") && !id.method_12832().contains("lava")) continue;
            filteredTextures.put(id, (ArrayImage)entry.getValue());
        }
        textures.keySet().removeAll(filteredTextures.keySet());
        parsedModifiers.keySet().removeAll(fluid.keySet());
        HashMap<class_2960, Parsed<FluidPropertyModifier>> converted = new HashMap<class_2960, Parsed<FluidPropertyModifier>>();
        for (Map.Entry f : fluid.entrySet()) {
            parsed = (Parsed)f.getValue();
            BlockPropertyModifier mod = (BlockPropertyModifier)parsed.getResultOrPartial();
            class_2960 id2 = (class_2960)f.getKey();
            Targets targets = mod.targets();
            targets.addSimple(id2);
            targets.addSimple(id2.method_45138("flowing_"));
            Optional<BlockPropertyModifier> fogMod = Optional.ofNullable((Parsed)fog.get(id2.method_48331("_fog"))).map(Parsed::getResultOrPartial);
            FluidPropertyModifier modifier = new FluidPropertyModifier(mod.tintGetter(), fogMod.map(BlockPropertyModifier::getColormap), Optional.empty(), Optional.empty(), targets);
            Parsed<FluidPropertyModifier> parsedModifier = Parsed.lowPriority(modifier, id2, parsed.isEnabled());
            converted.put(id2, parsedModifier);
        }
        Polytone.FLUID_MODIFIERS.addConvertedBlockProperties(converted, filteredTextures);
    }

    public static void convertOfBlockToDimensionProperties(LinkedListMultimap<class_2960, Parsed<BlockPropertyModifier>> parsedModifiers, Map<class_2960, ArrayImage> textures) {
        Object modifier;
        String stringId;
        class_2960 id;
        HashMap<class_2960, Parsed<BlockPropertyModifier>> filtered = new HashMap<class_2960, Parsed<BlockPropertyModifier>>();
        HashMap<class_2960, ArrayImage> filteredTextures = new HashMap<class_2960, ArrayImage>();
        Pattern fogP = Pattern.compile("minecraft:(?:fog|fogcolor)[0-2]\\b");
        Pattern skyP = Pattern.compile("minecraft:(?:sky|skycolor)[0-2]\\b");
        for (Map.Entry entry : parsedModifiers.entries()) {
            id = (class_2960)entry.getKey();
            stringId = id.toString();
            modifier = (Parsed)entry.getValue();
            if (!fogP.matcher(stringId).matches() && !skyP.matcher(stringId).matches()) continue;
            filtered.put(id, (Parsed<BlockPropertyModifier>)modifier);
        }
        for (Map.Entry entry : textures.entrySet()) {
            id = (class_2960)entry.getKey();
            stringId = id.toString();
            modifier = (ArrayImage)entry.getValue();
            if (!fogP.matcher(stringId).matches() && !skyP.matcher(stringId).matches()) continue;
            filteredTextures.put(id, (ArrayImage)modifier);
        }
        textures.keySet().removeAll(filteredTextures.keySet());
        parsedModifiers.keySet().removeAll(filtered.keySet());
        LegacyHelper.addConvertedBlockProperties(filtered, filteredTextures);
    }

    private static void addConvertedBlockProperties(Map<class_2960, Parsed<BlockPropertyModifier>> modifiers, Map<class_2960, ArrayImage> textures) {
        String[] names = new String[]{"overworld", "the_nether", "the_end"};
        HashMap<class_2960, Parsed<DimensionEffectsModifier>> converted = new HashMap<class_2960, Parsed<DimensionEffectsModifier>>();
        for (int i = 0; i <= 2; ++i) {
            boolean fogEnabled;
            IColorGetter fogCol;
            IColorGetter skyCol;
            class_2960 skyKey = class_2960.method_12829((String)("sky" + i));
            class_2960 skyKey2 = class_2960.method_12829((String)("skycolor" + i));
            Parsed<BlockPropertyModifier> skyMod = modifiers.get(skyKey);
            if (skyMod == null) {
                skyMod = modifiers.get(skyKey2);
                skyKey = skyKey2;
            }
            ArrayImage skyImage = textures.get(skyKey);
            IColorGetter iColorGetter = skyMod != null ? skyMod.getResultOrPartial().getColormap() : (skyCol = skyImage == null ? null : Colormap.createDefTriangle());
            if (skyCol != null) {
                ColormapsManager.tryAcceptingTexture(textures, skyKey, skyCol, new HashSet<class_2960>(), true);
            }
            boolean skyEnabled = skyMod == null || skyMod.isEnabled();
            class_2960 fogKey = new class_2960("fog" + i);
            class_2960 fogKey2 = new class_2960("fogcolor" + i);
            Parsed<BlockPropertyModifier> fogMod = modifiers.get(fogKey);
            if (fogMod == null) {
                fogMod = modifiers.get(fogKey2);
                fogKey = fogKey2;
            }
            ArrayImage fogImage = textures.get(fogKey);
            IColorGetter iColorGetter2 = fogMod != null ? fogMod.getResultOrPartial().getColormap() : (fogCol = fogImage == null ? null : Colormap.createDefTriangle());
            if (fogCol != null) {
                ColormapsManager.tryAcceptingTexture(textures, fogKey, fogCol, new HashSet<class_2960>(), true);
            }
            boolean bl = fogEnabled = fogMod == null || fogMod.isEnabled();
            if (fogCol == null && skyCol == null) continue;
            DimensionEffectsModifier mod = new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(fogCol), Optional.ofNullable(skyCol), Optional.empty(), false, false, Optional.empty(), DimensionTarget.EMPTY);
            class_2960 id = new class_2960(names[i]);
            boolean enabled = fogEnabled || skyEnabled;
            Parsed<DimensionEffectsModifier> parsedMod = Parsed.lowPriority(mod, id, enabled);
            converted.put(id, parsedMod);
        }
        Polytone.DIMENSION_MODIFIERS.addConvertedBlockProperties(converted);
    }
}

