/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.mojang.serialization.Codec;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.BiomeKeysCache;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public interface BiomeIdMapper {
    public static final Codec<BiomeIdMapper> CODEC = new ReferenceOrDirectCodec<Custom>(Polytone.BIOME_ID_MAPPERS.byNameCodec(), Custom.CUSTOM_CODEC, false);
    public static final BiomeIdMapper BY_INDEX = biome -> {
        int id = LegacyHelper.getBiomeId(biome);
        return (float)(id + 1) / 256.0f;
    };

    public float getIndex(Biome var1);

    public record Custom(Map<ResourceKey<Biome>, Float> map, float textureSize) implements BiomeIdMapper
    {
        public static final Codec<Custom> CUSTOM_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC.xmap(r -> ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)r), ResourceKey::location), (Codec)Codec.FLOAT).xmap(Custom::new, Custom::map);

        public Custom(Map<ResourceKey<Biome>, Float> map) {
            this(map, map.getOrDefault(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"texture_size")), Float.valueOf(1.0f)).floatValue());
        }

        @Override
        public float getIndex(Biome biome) {
            return (this.map.getOrDefault(BiomeKeysCache.get(biome), Float.valueOf(0.0f)).floatValue() + 1.0f) / this.textureSize;
        }
    }
}

