/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.IExpression;
import net.mehvahdjukaar.polytone.utils.exp.PolytoneExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockContextExpression
extends PolytoneExpression {
    public static final Codec<BlockContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new BlockContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasState;
    public static final BlockContextExpression ZERO = new BlockContextExpression("0");
    public static final BlockContextExpression ONE = new BlockContextExpression("1");
    public static final BlockContextExpression PARTICLE_RAND = new BlockContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public BlockContextExpression(String unparsed) {
        this(unparsed, false);
    }

    public BlockContextExpression(String unparsed, boolean concurrent) {
        super(unparsed, concurrent);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    protected BlockContextExpression createConcurrent() {
        return new BlockContextExpression(this.getUnparsed(), true);
    }

    @Override
    protected void buildFunctions(PolytoneExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.add(STATE_PROP);
        builder.add(STATE_PROP_INT);
    }

    public double getValue(Vec3 pos, float entityTime, Level level) {
        Entity e;
        ExpressionUtils.randomizeRandom();
        IExpression.IVars vb = this.expression.varBuilder();
        if (this.hasPos) {
            vb.setVariable("POS_X", pos.x);
            vb.setVariable("POS_Y", pos.y);
            vb.setVariable("POS_Z", pos.z);
        }
        BlockPos p = BlockPos.containing((Position)pos);
        if (this.hasTime) {
            vb.setVariable("TIME", entityTime);
        }
        if (this.hasDayTime) {
            vb.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vb.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vb.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            vb.setVariable("SKY_LIGHT", level.getBrightness(LightLayer.SKY, p));
        }
        if (this.hasBlockLight) {
            vb.setVariable("BLOCK_LIGHT", level.getBrightness(LightLayer.BLOCK, p));
        }
        if (this.hasTemperature) {
            vb.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((Biome)((Biome)level.getBiome((BlockPos)p).value())).temperature);
        }
        if (this.hasDownfall) {
            vb.setVariable("DOWNFALL", ColorUtils.getClimateSettings((Biome)((Biome)level.getBiome((BlockPos)p).value())).downfall);
        }
        if (this.hasState) {
            STATE_HACK.set(level.getBlockState(p));
        }
        if (this.hasPlayer) {
            e = Minecraft.getInstance().getCameraEntity();
            vb.setVariable("PLAYER_X", e.getX());
            vb.setVariable("PLAYER_Y", e.getY());
            vb.setVariable("PLAYER_Z", e.getZ());
        }
        if (this.hasDistance) {
            e = Minecraft.getInstance().getCameraEntity();
            double x = pos.x - e.getX();
            double y = pos.y - e.getY();
            double z = pos.z - e.getZ();
            vb.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vb.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vb.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vb);
    }

    public double getValue(Level level, @NotNull BlockPos pos, BlockState state) {
        Entity e;
        ExpressionUtils.seedRandom((long)pos.hashCode() * pos.asLong());
        IExpression.IVars vars = this.expression.varBuilder();
        if (this.hasPos) {
            vars.setVariable("POS_X", pos.getX());
            vars.setVariable("POS_Y", pos.getY());
            vars.setVariable("POS_Z", pos.getZ());
        }
        if (this.hasTime) {
            vars.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            vars.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            vars.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            vars.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            vars.setVariable("SKY_LIGHT", level.getBrightness(LightLayer.SKY, pos));
        }
        if (this.hasBlockLight) {
            vars.setVariable("BLOCK_LIGHT", level.getBrightness(LightLayer.BLOCK, pos));
        }
        if (this.hasTemperature) {
            vars.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((Biome)((Biome)level.getBiome((BlockPos)pos).value())).temperature);
        }
        if (this.hasDownfall) {
            vars.setVariable("DOWNFALL", ColorUtils.getClimateSettings((Biome)((Biome)level.getBiome((BlockPos)pos).value())).downfall);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        if (this.hasPlayer) {
            e = Minecraft.getInstance().getCameraEntity();
            vars.setVariable("PLAYER_X", e.getX());
            vars.setVariable("PLAYER_Y", e.getY());
            vars.setVariable("PLAYER_Z", e.getZ());
        }
        if (this.hasDistance) {
            e = Minecraft.getInstance().getCameraEntity();
            double x = (double)pos.getX() - e.getX();
            double y = (double)pos.getY() - e.getY();
            double z = (double)pos.getZ() - e.getZ();
            vars.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            vars.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            vars.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate(vars);
    }
}

