/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.particle.BlockParticleEmitter;
import net.mehvahdjukaar.polytone.sound.BlockSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockPropertiesManager
extends PartialReloader<Resources> {
    private final Map<Block, BlockPropertyModifier> vanillaProperties = new HashMap<Block, BlockPropertyModifier>();
    private final Map<Block, BlockPropertyModifier> modifiers = new HashMap<Block, BlockPropertyModifier>();
    private final Map<Block, ClientTickModifier> particleAndSoundEmitters = new Object2ObjectOpenHashMap();
    private ColorResolver vanillaGrassColorResolver = null;
    private ColorResolver vanillaFoliageColorResolver = null;
    private final Map<ResourceLocation, String> optifineColormapsToBlocks = new HashMap<ResourceLocation, String>();

    public BlockPropertiesManager() {
        super("block_modifiers", "block_properties");
    }

    @Nullable
    public Vec3 maybeModifyOffset(BlockState state, BlockPos pos) {
        Optional<BlockBehaviour.OffsetFunction> of;
        BlockPropertyModifier modifier = this.modifiers.get(state.getBlock());
        if (modifier != null && (of = modifier.offsetType()).isPresent()) {
            return of.get().evaluate(state, pos);
        }
        return null;
    }

    public boolean hasVisualOffset(BlockState state) {
        BlockPropertyModifier modifier = this.modifiers.get(state.getBlock());
        return modifier != null && modifier.offsetType().isPresent();
    }

    public void addExtraDestroyParticles(BlockState state, ClientLevel level, BlockPos pos, BlockState state1) {
        BlockPropertyModifier modifier = this.modifiers.get(state.getBlock());
        if (modifier != null) {
            List<BlockParticleEmitter> of = modifier.destroyParticleEmitters();
            for (BlockParticleEmitter p : of) {
                p.tick((Level)level, pos, state1);
            }
        }
    }

    @Override
    protected Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>();
        Map<ResourceLocation, ArrayImage> ofTextures = ArrayImage.scanDirectory(resourceManager, "optifine/colormap");
        Map<ResourceLocation, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        Map<ResourceLocation, Properties> ofProperties = PropertiesUtils.gatherProperties(resourceManager, "optifine/colormap");
        HashMap<ResourceLocation, JsonElement> ofJsons = new HashMap<ResourceLocation, JsonElement>();
        BlockPropertiesManager.scanDirectory(resourceManager, "optifine/colormap", GSON, ofJsons);
        ofJsons.forEach((k, v) -> ofProperties.put((ResourceLocation)k, PropertiesUtils.jsonToProperties(v)));
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new Resources((Map<ResourceLocation, JsonElement>)ImmutableMap.copyOf(jsons), (Map<ResourceLocation, ArrayImage>)ImmutableMap.copyOf(textures), (Map<ResourceLocation, Properties>)ImmutableMap.copyOf(LegacyHelper.convertPaths(ofProperties)));
    }

    @Override
    protected void parseWithLevel(Resources resources, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        ResourceLocation id;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, ArrayImage.Group> textures = ArrayImage.groupTextures(resources.textures());
        HashMap<ResourceLocation, ArrayImage> textureCopy = new HashMap<ResourceLocation, ArrayImage>(resources.textures);
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        Map<ResourceLocation, Parsed<BlockPropertyModifier>> parsedModifiers = Utils.sortedMap();
        parsedModifiers.putAll(LegacyHelper.convertBlockProperties(resources.ofProperties, textureCopy));
        parsedModifiers.putAll(LegacyHelper.convertInlinedPalettes(this.optifineColormapsToBlocks));
        LegacyHelper.convertOfBlockToFluidProp(parsedModifiers, textureCopy);
        LegacyHelper.convertOfBlockToDimensionProperties(parsedModifiers, textureCopy);
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id2 = entry.getKey();
            Parsed<BlockPropertyModifier> prop = Parsed.parseOptionalOrPartial(BlockPropertyModifier.CODEC, BlockPropertyModifier.PARTIAL_CODEC, json, ops, id2, "block modifier");
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate block modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, prop);
        }
        for (Map.Entry<ResourceLocation, Object> entry : parsedModifiers.entrySet()) {
            id = entry.getKey();
            Parsed result = (Parsed)entry.getValue();
            BlockPropertyModifier modifier = (BlockPropertyModifier)result.getResultOrPartial();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                ArrayImage.Group text = textures.get(id);
                IndexCompoundColorGetter defaultSampler = IndexCompoundColorGetter.createDefault((Set<Integer>)text.keySet(), true);
                modifier = modifier.merge(BlockPropertyModifier.ofBlockColor(defaultSampler));
            }
            IColorGetter tint = modifier.getColormap();
            ColormapsManager.tryAcceptingTextureGroup(textures, id, tint, usedTextures, true);
            if (!result.isEnabled()) continue;
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            id = entry.getKey();
            ArrayImage.Group image = (ArrayImage.Group)((Object)entry.getValue());
            IndexCompoundColorGetter tintMap = IndexCompoundColorGetter.createDefault((Set<Integer>)image.keySet(), true);
            ColormapsManager.tryAcceptingTextureGroup(textures, id, (BlockColor)tintMap, usedTextures, true);
            BlockPropertyModifier modifier = BlockPropertyModifier.ofBlockColor(tintMap);
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(ResourceLocation fileId, BlockPropertyModifier mod) {
        for (Holder block : mod.targets().compute(fileId, BuiltInRegistries.BLOCK)) {
            this.modifiers.merge((Block)block.value(), mod, BlockPropertyModifier::merge);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<Block, BlockPropertyModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
        }
        this.vanillaProperties.clear();
        this.modifiers.clear();
        this.optifineColormapsToBlocks.clear();
        this.particleAndSoundEmitters.clear();
        if (this.vanillaGrassColorResolver != null) {
            BiomeColors.GRASS_COLOR_RESOLVER = this.vanillaGrassColorResolver;
        }
        this.vanillaGrassColorResolver = null;
        if (this.vanillaFoliageColorResolver != null) {
            BiomeColors.FOLIAGE_COLOR_RESOLVER = this.vanillaFoliageColorResolver;
        }
        this.vanillaFoliageColorResolver = null;
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
        for (Map.Entry<Block, BlockPropertyModifier> e : this.modifiers.entrySet()) {
            List<BlockSoundEmitter> sound;
            Block target = e.getKey();
            BlockPropertyModifier value = e.getValue();
            this.vanillaProperties.put(target, value.apply(target));
            List<BlockParticleEmitter> particle = value.particleEmitters();
            if (!particle.isEmpty()) {
                this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ClientTickModifier()).addAll(particle);
            }
            if (!(sound = value.soundEmitters()).isEmpty()) {
                this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ClientTickModifier()).addAll(sound);
            }
            if (!value.disableParticles().booleanValue()) continue;
            this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ClientTickModifier()).cancelsExisting();
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Block Modifiers", (Object)this.vanillaProperties.size());
        }
    }

    protected void maybeAssignToDefaultGrassAndFoliage(Block block, BlockColor color) {
        ColorResolver cc = null;
        if (color instanceof IndexCompoundColorGetter) {
            IndexCompoundColorGetter ic = (IndexCompoundColorGetter)color;
            for (Int2ObjectMap.Entry e : ic.getGetters().int2ObjectEntrySet()) {
                ColorResolver c;
                if (!(e instanceof ColorResolver)) continue;
                cc = c = (ColorResolver)e;
                break;
            }
        }
        if (block == Blocks.GRASS_BLOCK && cc != null) {
            this.vanillaGrassColorResolver = BiomeColors.GRASS_COLOR_RESOLVER;
            BiomeColors.GRASS_COLOR_RESOLVER = cc;
        } else if (block == Blocks.OAK_LEAVES && cc != null) {
            this.vanillaFoliageColorResolver = BiomeColors.FOLIAGE_COLOR_RESOLVER;
            BiomeColors.FOLIAGE_COLOR_RESOLVER = cc;
        }
    }

    public void addSimpleColormap(ResourceLocation path, String str) {
        this.optifineColormapsToBlocks.put(path, str);
    }

    public boolean maybeEmitParticle(Block block, BlockState state, Level level, BlockPos pos) {
        ClientTickModifier m = this.particleAndSoundEmitters.get(block);
        if (m != null) {
            for (BlockClientTickable p : m.tickables) {
                p.tick(level, pos, state);
            }
            return m.cancelExisting;
        }
        return false;
    }

    public record Resources(Map<ResourceLocation, JsonElement> jsons, Map<ResourceLocation, ArrayImage> textures, Map<ResourceLocation, Properties> ofProperties) {
    }

    private static class ClientTickModifier {
        final List<BlockClientTickable> tickables = new ArrayList<BlockClientTickable>();
        boolean cancelExisting;

        private ClientTickModifier() {
        }

        public void add(BlockClientTickable tickable) {
            this.tickables.add(tickable);
        }

        public void cancelsExisting() {
            this.cancelExisting = true;
        }

        public void addAll(List<? extends BlockClientTickable> emitters) {
            this.tickables.addAll(emitters);
        }
    }
}

