/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.item.AutoGeneratedModel;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.item.ItemModelOverrideList;
import net.mehvahdjukaar.polytone.item.StandaloneItemModelOverride;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.ModelResHelper;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CustomItemModelsManager
extends JsonPartialReloader {
    private final Map<Item, ItemModelOverrideList> itemModels = new Object2ObjectOpenHashMap();
    private final Set<AutoGeneratedModel> autoGeneratedModels = new HashSet<AutoGeneratedModel>();
    private final Map<Item, List<ItemModelOverride>> itemModifiersModels = new HashMap<Item, List<ItemModelOverride>>();

    public CustomItemModelsManager() {
        super("custom_item_models");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.itemModels.clear();
        this.autoGeneratedModels.clear();
    }

    @Override
    protected void earlyProcess(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            ResourceLocation id;
            JsonElement json = e.getValue();
            StandaloneItemModelOverride.Partial partial = Parsed.parseOrNull(StandaloneItemModelOverride.CODEC_MODEL_ONLY, json, JsonOps.INSTANCE, id = e.getKey(), "custom item model");
            if (partial == null || partial.autoModel()) continue;
            Polytone.addCustomModel(partial.model());
        }
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        this.itemModels.clear();
        this.autoGeneratedModels.clear();
        for (Map.Entry<Item, List<ItemModelOverride>> entry : this.itemModifiersModels.entrySet()) {
            Item target = entry.getKey();
            List<ItemModelOverride> overrides = entry.getValue();
            this.itemModels.computeIfAbsent(target, a -> new ItemModelOverrideList()).addAll(overrides);
        }
        this.itemModifiersModels.clear();
        for (Map.Entry<Item, List<ItemModelOverride>> entry : jsons.entrySet()) {
            ResourceLocation location;
            JsonElement json = (JsonElement)entry.getValue();
            StandaloneItemModelOverride modelOverride = Parsed.parseOrNull(StandaloneItemModelOverride.CODEC, json, ops, location = (ResourceLocation)entry.getKey(), "custom item model");
            if (modelOverride == null) continue;
            if (modelOverride.isAutoModel()) {
                AutoGeneratedModel generated = AutoGeneratedModel.ofCIM(location);
                this.autoGeneratedModels.add(generated);
                modelOverride.setModel(ModelResHelper.of(generated.modelLocation()));
            }
            this.itemModels.computeIfAbsent(modelOverride.getTarget(), a -> new ItemModelOverrideList()).add(modelOverride);
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
        for (ItemModelOverrideList list : this.itemModels.values()) {
            list.populateModels(access);
        }
        int allModels = 0;
        for (ItemModelOverrideList list : this.itemModels.values()) {
            allModels += list.size();
        }
        Polytone.LOGGER.info("Loaded {} Custom Item Models for {} items", (Object)allModels, (Object)this.itemModels.size());
    }

    @Nullable
    public BakedModel getOverride(ItemStack itemStack, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        if (level == null) {
            return null;
        }
        ItemModelOverrideList list = this.itemModels.get(itemStack.getItem());
        if (list == null) {
            return null;
        }
        return list.getModel(itemStack, level, entity, seed);
    }

    public Map<ResourceLocation, BlockModel> createAutoGeneratedModels() {
        HashMap<ResourceLocation, BlockModel> models = new HashMap<ResourceLocation, BlockModel>();
        for (AutoGeneratedModel model : this.autoGeneratedModels) {
            String texturePath = model.texturePath().toString();
            try (StringReader reader = new StringReader(String.format("{\n  \"parent\": \"item/generated\",\n  \"textures\": {\n    \"layer0\": \"%s\"\n  }\n}\n", texturePath));){
                BlockModel unbakedModel = BlockModel.fromStream((Reader)reader);
                models.put(model.modelLocation(), unbakedModel);
            }
        }
        return models;
    }

    public void addModelFromModifier(Item item, List<ItemModelOverride> itemModelOverrides) {
        this.itemModifiersModels.computeIfAbsent(item, a -> new ArrayList()).addAll(itemModelOverrides);
    }
}

