/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record BlockParticleEmitter(ParticleType<?> particleType, BlockContextExpression chance, BlockContextExpression count, BlockContextExpression x, BlockContextExpression y, BlockContextExpression z, BlockContextExpression dx, BlockContextExpression dy, BlockContextExpression dz, RuleTest predicate, Optional<HolderSet<Biome>> biomes, SpawnLocation spawnLocation) implements BlockClientTickable
{
    public static final Codec<BlockParticleEmitter> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.PARTICLE_TYPE.byNameCodec().fieldOf("particle").forGetter(BlockParticleEmitter::particleType), (App)BlockContextExpression.CODEC.optionalFieldOf("chance", (Object)BlockContextExpression.ONE).forGetter(BlockParticleEmitter::chance), (App)BlockContextExpression.CODEC.optionalFieldOf("count", (Object)BlockContextExpression.ONE).forGetter(BlockParticleEmitter::count), (App)BlockContextExpression.CODEC.optionalFieldOf("x", (Object)BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::x), (App)BlockContextExpression.CODEC.optionalFieldOf("y", (Object)BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::y), (App)BlockContextExpression.CODEC.optionalFieldOf("z", (Object)BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::z), (App)BlockContextExpression.CODEC.optionalFieldOf("dx", (Object)BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dx), (App)BlockContextExpression.CODEC.optionalFieldOf("dy", (Object)BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dy), (App)BlockContextExpression.CODEC.optionalFieldOf("dz", (Object)BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dz), (App)RuleTest.CODEC.optionalFieldOf("state_predicate", (Object)AlwaysTrueTest.INSTANCE).forGetter(BlockParticleEmitter::predicate), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(BlockParticleEmitter::biomes), (App)SpawnLocation.CODEC.optionalFieldOf("spawn_location", (Object)SpawnLocation.CENTER).forGetter(BlockParticleEmitter::spawnLocation)).apply((Applicative)i, BlockParticleEmitter::new));

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        double spawnChance = this.chance.getValue(level, pos, state);
        if ((double)level.random.nextFloat() < spawnChance && this.predicate().test(state, level.random)) {
            if (this.biomes.isPresent()) {
                Holder biome = level.getBiome(pos);
                if (!this.biomes.get().contains(biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(level, pos, state)) {
                CustomParticleType.setStateHack(state);
                ParticleOptions po = this.getParticleOptions(state);
                if (po == null) {
                    return;
                }
                level.addAlwaysVisibleParticle(po, (double)pos.getX() + this.x.getValue(level, pos, state), (double)pos.getY() + this.y.getValue(level, pos, state), (double)pos.getZ() + this.z.getValue(level, pos, state), this.dx.getValue(level, pos, state), this.dy.getValue(level, pos, state), this.dz.getValue(level, pos, state));
                ++i;
            }
        }
    }

    @Nullable
    private ParticleOptions getParticleOptions(BlockState state) {
        SimpleParticleType po;
        ParticleType<?> particleType = this.particleType;
        if (particleType instanceof SimpleParticleType) {
            SimpleParticleType st;
            po = st = (SimpleParticleType)particleType;
        } else if (this.particleType == ParticleTypes.BLOCK || this.particleType == ParticleTypes.FALLING_DUST || this.particleType == ParticleTypes.BLOCK_MARKER || this.particleType == ParticleTypes.DUST_PILLAR) {
            po = new BlockParticleOption(this.particleType, state);
        } else if (this.particleType == ParticleTypes.ITEM) {
            po = new ItemParticleOption(this.particleType, state.getBlock().asItem().getDefaultInstance());
        } else {
            Polytone.LOGGER.error("Unsupported particle type: {}", this.particleType);
            return null;
        }
        return po;
    }

    public static Vec3 getParticleSpawnPosOnFace(RandomSource random, BlockPos pos, Direction direction) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        int i = direction.getStepX();
        int j = direction.getStepY();
        int k = direction.getStepZ();
        double d0 = vec3.x + (i == 0 ? Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.y + (j == 0 ? Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.z + (k == 0 ? Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        return new Vec3(d0, d1, d2);
    }

    public static enum SpawnLocation {
        CENTER,
        LOWER_CORNER,
        BLOCK_FACES;

        public static final Codec<SpawnLocation> CODEC;

        Vec3 getLocation(BlockPos pos, BlockState state, RandomSource rand) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> Vec3.atLowerCornerOf((Vec3i)pos);
                case 0 -> Vec3.atCenterOf((Vec3i)pos);
                case 2 -> {
                    Direction dir = Direction.values()[rand.nextInt(Direction.values().length)];
                    yield BlockParticleEmitter.getParticleSpawnPosOnFace(rand, pos, dir);
                }
            };
        }

        static {
            CODEC = Codec.STRING.xmap(s -> SpawnLocation.valueOf(s.toUpperCase(Locale.ROOT)), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }
}

