/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.particle.SemiCustomParticleType;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class CustomParticlesManager
extends JsonPartialReloader {
    public final MapRegistry<CustomParticleFactory> customParticleFactories = new MapRegistry("Custom Particles");
    private final Map<ParticleType<?>, ParticleProvider<?>> overwrittenVanillaProviders = new HashMap();
    public static final Codec<CustomParticleFactory> CUSTOM_OR_SEMI_CUSTOM_CODEC = Codec.either(SemiCustomParticleType.CODEC, CustomParticleType.CODEC).xmap(e -> (CustomParticleFactory)e.map(Function.identity(), Function.identity()), p -> {
        Either either;
        if (p instanceof CustomParticleType) {
            CustomParticleType c = (CustomParticleType)p;
            either = Either.right((Object)c);
        } else {
            either = Either.left((Object)((SemiCustomParticleType)p));
        }
        return either;
    });

    public CustomParticlesManager() {
        super("custom_particles");
    }

    @Override
    public void earlyProcess(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            Optional model = (Optional)((Pair)CustomParticleType.CUSTOM_MODEL_ONLY_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Custom Particle with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            model.ifPresent(Polytone::addCustomModel);
        }
    }

    @Override
    protected void resetWithLevel(boolean isLogOff) {
        for (ResourceLocation resourceLocation : this.customParticleFactories.orderedKeys()) {
            CustomParticleFactory p = this.customParticleFactories.getValue(resourceLocation);
            if (p instanceof CustomParticleType) {
                CustomParticleType cp = (CustomParticleType)p;
                cp.setUnregistered();
            }
            PlatStuff.unregisterParticleProvider(resourceLocation);
            PlatStuff.unregisterDynamic(BuiltInRegistries.PARTICLE_TYPE, resourceLocation);
        }
        this.customParticleFactories.clear();
        for (Map.Entry entry : this.overwrittenVanillaProviders.entrySet()) {
            PlatStuff.setParticleProvider((ParticleType)entry.getKey(), (ParticleProvider)entry.getValue());
        }
        this.overwrittenVanillaProviders.clear();
    }

    public void addSpriteSets(ResourceManager resourceManager) {
        ParticleEngine engine = Minecraft.getInstance().particleEngine;
        for (ResourceLocation object : this.customParticleFactories.keySet()) {
        }
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (ResourceLocation v : jsons.keySet()) {
            engine.spriteSets.put(v, new ParticleEngine.MutableSpriteSet());
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        ResourceLocation id;
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        HashSet<CustomParticleType> customTypes = new HashSet<CustomParticleType>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            try {
                JsonObject jo;
                JsonElement json = entry.getValue();
                id = entry.getKey();
                CustomParticleFactory factory = json instanceof JsonObject && (jo = (JsonObject)json).has("copy_from") ? (CustomParticleFactory)Parsed.parseOrNull(SemiCustomParticleType.CODEC, json, ops, id, "custom particle") : (CustomParticleFactory)Parsed.parseOrNull(CustomParticleType.CODEC, json, ops, id, "custom particle");
                if (factory == null) continue;
                factory.setSpriteSet((ParticleEngine.MutableSpriteSet)Minecraft.getInstance().particleEngine.spriteSets.get(id));
                if (factory instanceof CustomParticleType) {
                    CustomParticleType c = (CustomParticleType)factory;
                    customTypes.add(c);
                }
                if (BuiltInRegistries.PARTICLE_TYPE.get(id).isPresent()) {
                    ParticleType oldType = (ParticleType)((Holder.Reference)BuiltInRegistries.PARTICLE_TYPE.get(id).get()).value();
                    Polytone.LOGGER.info("Overriding particle with id {}", (Object)id);
                    ParticleProvider<?> oldFactory = PlatStuff.getParticleProvider(oldType);
                    this.overwrittenVanillaProviders.put(oldType, oldFactory);
                    try {
                        particleEngine.register(oldType, (ParticleProvider)factory);
                    }
                    catch (Exception e) {
                        Polytone.LOGGER.error("Can't override existing particle with ID {}. Particle type not supported", (Object)id, (Object)e);
                    }
                    continue;
                }
                this.customParticleFactories.register(id, factory);
                Polytone.LOGGER.info("Registered Custom Particle {}", (Object)id);
            }
            catch (Exception e) {
                Polytone.LOGGER.error("!!!!!!!!!!!! Failed to load Custom Particle {}", (Object)entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry<ResourceLocation, Object> entry : this.customParticleFactories.getEntries()) {
            CustomParticleFactory factory = (CustomParticleFactory)entry.getValue();
            id = entry.getKey();
            SimpleParticleType type = PlatStuff.makeParticleType(factory.forceSpawns());
            PlatStuff.registerDynamic(BuiltInRegistries.PARTICLE_TYPE, id, type);
            particleEngine.register((ParticleType)type, (ParticleProvider)factory);
        }
        for (CustomParticleType customParticleType : customTypes) {
            for (Dynamic<?> d : customParticleType.lazyParticles) {
                try {
                    customParticleType.particles.add(CustomParticlesManager.runCodec(ops, d));
                }
                catch (Exception e) {
                    Polytone.LOGGER.error("Failed to initialize custom particles particle emitters", (Throwable)e);
                }
            }
            customParticleType.lazyParticles = null;
        }
    }

    private static <T> ParticleParticleEmitter runCodec(DynamicOps o, Dynamic<T> dynamic) {
        DynamicOps ops = o;
        return (ParticleParticleEmitter)((Pair)ParticleParticleEmitter.CODEC.decode(ops, dynamic.getValue()).getOrThrow()).getFirst();
    }

    public Codec<CustomParticleFactory> byNameCodec() {
        return this.customParticleFactories;
    }

    public boolean isDynamicParticle(ResourceLocation entryId) {
        return this.customParticleFactories.containsKey(entryId);
    }
}

