/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public record ParticleParticleEmitter(SimpleParticleType particleType, ParticleContextExpression chance, ParticleContextExpression count, ParticleContextExpression x, ParticleContextExpression y, ParticleContextExpression z, ParticleContextExpression dx, ParticleContextExpression dy, ParticleContextExpression dz, Optional<HolderSet<Biome>> biomes) implements ParticleTickable
{
    public static final Codec<ParticleParticleEmitter> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.PARTICLE_TYPE.byNameCodec().validate(pt -> {
        if (pt instanceof SimpleParticleType) {
            return DataResult.success((Object)pt);
        }
        return DataResult.error(() -> "Unsupported particle type: " + String.valueOf(pt));
    }).xmap(pt -> (SimpleParticleType)pt, pt -> pt).fieldOf("particle").forGetter(ParticleParticleEmitter::particleType), (App)ParticleContextExpression.CODEC.optionalFieldOf("chance", (Object)ParticleContextExpression.ONE).forGetter(ParticleParticleEmitter::chance), (App)ParticleContextExpression.CODEC.optionalFieldOf("count", (Object)ParticleContextExpression.ONE).forGetter(ParticleParticleEmitter::count), (App)ParticleContextExpression.CODEC.optionalFieldOf("x", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::x), (App)ParticleContextExpression.CODEC.optionalFieldOf("y", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::y), (App)ParticleContextExpression.CODEC.optionalFieldOf("z", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::z), (App)ParticleContextExpression.CODEC.optionalFieldOf("dx", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dx), (App)ParticleContextExpression.CODEC.optionalFieldOf("dy", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dy), (App)ParticleContextExpression.CODEC.optionalFieldOf("dz", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dz), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(ParticleParticleEmitter::biomes)).apply((Applicative)i, ParticleParticleEmitter::new));

    @Override
    public void tick(Particle particle, Level level) {
        double spawnChance = this.chance.getValue(particle, level);
        if ((double)level.random.nextFloat() < spawnChance) {
            if (this.biomes.isPresent()) {
                Holder biome = level.getBiome(BlockPos.containing((double)particle.x, (double)particle.y, (double)particle.z));
                if (!this.biomes.get().contains(biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(particle, level)) {
                level.addParticle((ParticleOptions)this.particleType, particle.x + this.x.getValue(particle, level), particle.y + this.y.getValue(particle, level), particle.z + this.z.getValue(particle, level), this.dx.getValue(particle, level), this.dy.getValue(particle, level), this.dz.getValue(particle, level));
                ++i;
            }
        }
    }
}

