/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.slotify.RelativeSprite;
import net.mehvahdjukaar.polytone.slotify.SimpleSprite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

public record BlitModifier(ResourceLocation target, int index, int x, int y, int z, int width, int height, float u0, float v0, float u1, float v1, int color, Optional<ResourceLocation> newTexture, List<RelativeSprite> extraSprites) {
    public static final Codec<BlitModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(BlitModifier::target), (App)Codec.INT.optionalFieldOf("index", (Object)-1).forGetter(BlitModifier::index), (App)Codec.INT.optionalFieldOf("x_inc", (Object)0).forGetter(BlitModifier::x), (App)Codec.INT.optionalFieldOf("y_inc", (Object)0).forGetter(BlitModifier::y), (App)Codec.INT.optionalFieldOf("z_inc", (Object)0).forGetter(BlitModifier::z), (App)Codec.INT.optionalFieldOf("width_inc", (Object)0).forGetter(BlitModifier::width), (App)Codec.INT.optionalFieldOf("height_inc", (Object)0).forGetter(BlitModifier::height), (App)Codec.FLOAT.optionalFieldOf("u0", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::u0), (App)Codec.FLOAT.optionalFieldOf("v0", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::v0), (App)Codec.FLOAT.optionalFieldOf("u1", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::u1), (App)Codec.FLOAT.optionalFieldOf("v1", (Object)Float.valueOf(-1.0f)).forGetter(BlitModifier::v1), (App)Codec.INT.optionalFieldOf("color", (Object)-1).forGetter(BlitModifier::color), (App)ResourceLocation.CODEC.optionalFieldOf("new_texture").forGetter(BlitModifier::newTexture), (App)RelativeSprite.CODEC.listOf().optionalFieldOf("overlays", List.of()).forGetter(BlitModifier::extraSprites)).apply((Applicative)i, BlitModifier::new));

    public void blitModified(GuiGraphics gui, Function<ResourceLocation, RenderType> function, MultiBufferSource.BufferSource bufferSource, TextureAtlasSprite sprite, int x1, int x2, int y1, int y2, int tint) {
        int col = this.color == -1 ? tint : this.color;
        for (RelativeSprite s : this.extraSprites) {
            s.render(gui.pose(), function, bufferSource, x1, x2, y1, y2, col);
        }
        if (this.newTexture.isPresent()) {
            sprite = Minecraft.getInstance().getGuiSprites().getSprite(this.newTexture.get());
        }
        float minU = this.u1 == -1.0f ? sprite.getU0() : this.u1;
        float maxU = this.u0 == -1.0f ? sprite.getU1() : this.u0;
        float minV = this.v1 == -1.0f ? sprite.getV0() : this.v1;
        float maxV = this.v0 == -1.0f ? sprite.getV1() : this.v0;
        int oldw = x2 - x1;
        x2 = (x1 += this.x) + (oldw += this.width);
        int oldh = y2 - y1;
        y2 = (y1 += this.y) + (oldh += this.height);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(function.apply(sprite.atlasLocation()));
        SimpleSprite.blit(gui.pose().last().pose(), vertexConsumer, x1, x2, y1, y2, this.z, minU, maxU, minV, maxV, col);
    }
}

