/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_703;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ParticleModifiersManager
extends JsonImgPartialReloader {
    private final Multimap<class_2396<?>, ParticleModifier> particleModifiers = HashMultimap.create();
    @Nullable
    private JsonElement xpOrbReplaceJson = null;
    @Nullable
    private class_2394 xpOrbReplaceParticle = null;

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(class_2394 options, class_1937 level, class_703 particle) {
        Collection mod = this.particleModifiers.get((Object)options.method_10295());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        Parsed v;
        class_2960 id;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        Parsed.SortedMap<ParticleModifier> parsedModifiers = Parsed.batchParseOrPartial(jsons, ParticleModifier.CODEC, ParticleModifier.PARTIAL_CODEC, ops, "particle modifier");
        for (Map.Entry<class_2960, Parsed<ParticleModifier>> entry : parsedModifiers.entrySet()) {
            id = entry.getKey();
            Parsed<ParticleModifier> parsed = entry.getValue();
            ParticleModifier modifier = parsed.getResultOrPartial();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                modifier.setColormap(Colormap.createDefTriangle());
            }
            class_322 tint = modifier.getColormap();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<class_2960, Object> entry : textures.entrySet()) {
            id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ParticleModifier.ofColormap(defaultColormap));
        }
        if (this.xpOrbReplaceJson != null && (v = Parsed.parseAlways(class_2398.field_25125, this.xpOrbReplaceJson, ops, new class_2960("xp_orb"), "XP orb modifier")).isEnabled()) {
            this.xpOrbReplaceParticle = (class_2394)v.getResultOrPartial();
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        if (!this.particleModifiers.isEmpty()) {
            Polytone.LOGGER.info("Registered {} particle modifiers", (Object)this.particleModifiers.size());
        }
    }

    private void addModifier(class_2960 pathId, ParticleModifier mod) {
        for (class_6880 p : mod.targets().compute(pathId, class_7923.field_41180)) {
            this.particleModifiers.put((Object)((class_2396)p.comp_349()), (Object)mod);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(class_2960 id, String color) {
        Optional opt = class_7923.field_41180.method_17966(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }

    public void setXpOrbReplace(JsonElement json) {
        this.xpOrbReplaceJson = json;
    }

    @Nullable
    public class_2394 getXpOrbReplaceParticle() {
        return this.xpOrbReplaceParticle;
    }
}

