/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CreativeTabsModifiersManager
extends PartialReloader<Resources> {
    private final MapRegistry<class_1761> customTabs = new MapRegistry("Custom Creative Tabs");
    private final Map<class_5321<class_1761>, CreativeTabModifier> modifiers = new HashMap<class_5321<class_1761>, CreativeTabModifier>();
    private final Set<class_5321<class_1761>> needsRefresh = new HashSet<class_5321<class_1761>>();
    private final Map<class_5321<class_1761>, CreativeTabModifier> vanillaTabs = new HashMap<class_5321<class_1761>, CreativeTabModifier>();

    public CreativeTabsModifiersManager() {
        super("creative_tab_modifiers");
    }

    @Override
    public Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        Map<class_2960, List<String>> types = CsvUtils.parseCsv(resourceManager, "creative_tabs");
        return new Resources((Map<class_2960, JsonElement>)ImmutableMap.copyOf(jsons), (Map<class_2960, List<String>>)ImmutableMap.copyOf(types));
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (class_2960 class_29602 : this.customTabs.keySet()) {
            PlatStuff.unregisterDynamic(class_7923.field_44687, class_29602);
            if (!logOff) continue;
            class_310.method_1551().method_18858(PlatStuff::sortTabs);
        }
        this.customTabs.clear();
        for (Map.Entry entry : this.vanillaTabs.entrySet()) {
            ((CreativeTabModifier)entry.getValue()).applyAttributes((class_5321<class_1761>)((class_5321)entry.getKey()));
        }
        this.vanillaTabs.clear();
        this.needsRefresh.addAll(this.modifiers.keySet());
        this.modifiers.clear();
        this.customTabs.clear();
    }

    @Override
    protected void parseWithLevel(Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        for (Map.Entry<class_2960, List<String>> entry : resources.extraTabs.entrySet()) {
            for (String str : entry.getValue()) {
                class_2960 id = entry.getKey().method_45136(str);
                this.registerNewTab(id);
            }
        }
        for (Map.Entry<class_2960, Object> entry : Parsed.batchParseOnlyEnabled(resources.tabsModifiers, CreativeTabModifier.CODEC, ops, "creative tab modifier")) {
            class_2960 id = entry.getKey();
            CreativeTabModifier mod = (CreativeTabModifier)entry.getValue();
            if (mod.registerTab()) {
                this.registerNewTab(id);
            }
            this.addModifier(entry.getKey(), (CreativeTabModifier)entry.getValue());
        }
        for (Map.Entry<class_2960, Object> entry : Parsed.batchParseOnlyEnabled(resources.tabsModifiers, CreativeTabModifier.CODEC, ops, "creative tab modifier")) {
            this.addModifier(entry.getKey(), (CreativeTabModifier)entry.getValue());
        }
        if (!this.customTabs.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Creative Tabs from Resource Packs: {}", (Object)this.customTabs.size(), (Object)(String.valueOf(this.customTabs) + ". Remember to add items to them!"));
            class_310.method_1551().method_18858(PlatStuff::sortTabs);
        }
    }

    private void registerNewTab(class_2960 id) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)id);
        if (!this.customTabs.containsKey(id) && !class_7923.field_44687.method_35842(key)) {
            class_1761 tab = PlatStuff.createCreativeTab(id);
            this.customTabs.register(id, tab);
            PlatStuff.registerDynamic(class_7923.field_44687, id, tab);
        } else {
            Polytone.LOGGER.error("Creative Tab with id {} already exists! Ignoring.", (Object)id);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        if (!this.modifiers.isEmpty()) {
            this.needsRefresh.addAll(this.modifiers.keySet());
        }
        if (!this.needsRefresh.isEmpty()) {
            class_7706.field_42466 = null;
            this.needsRefresh.clear();
        }
    }

    private void addModifier(class_2960 fileId, CreativeTabModifier mod) {
        Targets targets = mod.targets();
        if (mod.registerTab()) {
            targets = Targets.ofIds(fileId);
        }
        for (class_6880 tab : targets.compute(fileId, class_7923.field_44687)) {
            class_5321 key = (class_5321)tab.method_40230().get();
            this.modifiers.merge((class_5321<class_1761>)key, mod, CreativeTabModifier::merge);
            PlatStuff.addTabEventForTab((class_5321<class_1761>)key);
        }
    }

    public void modifyTab(ItemToTabEvent event) {
        class_5455 access;
        class_5321<class_1761> tab = event.getTab();
        CreativeTabModifier mod = this.modifiers.get(tab);
        if (mod != null && (access = PlatStuff.hackyGetRegistryAccess()) != null) {
            CreativeTabModifier v = mod.applyItemsAndAttributes(event, access);
            if (!this.customTabs.containsKey(tab.method_29177())) {
                this.vanillaTabs.put(tab, v);
            }
        }
    }

    public boolean isDynamicTab(class_2960 entryId) {
        return this.customTabs.containsKey(entryId);
    }

    public record Resources(Map<class_2960, JsonElement> tabsModifiers, Map<class_2960, List<String>> extraTabs) {
    }
}

