/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class PolytoneRenderTypes
extends RenderType {
    private static ShaderInstance noAlphaCutoffShader;
    public static final ParticleRenderType PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE;
    protected static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSLUCENT_TRANSPARENCY;
    private static final RenderStateShard.TextureStateShard PARTICLE_SHEET;
    protected static final RenderStateShard.ShaderStateShard PARTICLE_SHADER_STATE;
    public static final RenderType ADDITIVE_TRANSLUCENT_PARTICLE;
    public static final RenderType ADDITIVE_TRANSLUCENT_BLOCK;
    public static final DeferredBufferSource DEFERRED_BUFFER_SOURCE;
    private static Matrix4f lastModelViewMatrix;

    public static void init() {
        PlatStuff.registerShaders(Polytone.res("particle_translucent"), DefaultVertexFormat.POSITION_TEX, s -> {
            noAlphaCutoffShader = s;
        });
    }

    public PolytoneRenderTypes(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
        super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
    }

    public static void onRenderLast() {
        if (lastModelViewMatrix != null) {
            Matrix4f last = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            RenderSystem.getModelViewMatrix().set((Matrix4fc)lastModelViewMatrix);
            DEFERRED_BUFFER_SOURCE.endBatches();
            RenderSystem.getModelViewMatrix().set((Matrix4fc)last);
        } else {
            DEFERRED_BUFFER_SOURCE.endBatches();
        }
    }

    public static void cacheMatrices() {
        lastModelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
    }

    static {
        PARTICLE_ADDITIVE_TRANSLUCENCY_RENDER_TYPE = new ParticleRenderType(){

            public BufferBuilder begin(Tesselator builder, TextureManager textureManager) {
                Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
                RenderSystem.activeTexture((int)33986);
                RenderSystem.activeTexture((int)33984);
                RenderSystem.setShader(() -> noAlphaCutoffShader);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                return builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            }

            public String toString() {
                return "PARTICLE_SHEET_ADDITIVE_TRANSLUCENT";
            }
        };
        ADDITIVE_TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("polytone:additive_translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.depthMask((boolean)false);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
        });
        PARTICLE_SHEET = new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_PARTICLES, false, false);
        PARTICLE_SHADER_STATE = new RenderStateShard.ShaderStateShard(() -> noAlphaCutoffShader);
        ADDITIVE_TRANSLUCENT_PARTICLE = RenderType.create((String)"polytone:additive_translucent_particle", (VertexFormat)DefaultVertexFormat.PARTICLE, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(LIGHTMAP).setTextureState((RenderStateShard.EmptyTextureStateShard)PARTICLE_SHEET).setShaderState(PARTICLE_SHADER_STATE).setWriteMaskState(RenderStateShard.WriteMaskStateShard.COLOR_WRITE).setTransparencyState(ADDITIVE_TRANSLUCENT_TRANSPARENCY).createCompositeState(false));
        ADDITIVE_TRANSLUCENT_BLOCK = RenderType.create((String)"polytone:additive_translucent_block", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)786432, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(LIGHTMAP).setShaderState(RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setTransparencyState(ADDITIVE_TRANSLUCENT_TRANSPARENCY).setOutputState(TRANSLUCENT_TARGET).createCompositeState(true));
        DEFERRED_BUFFER_SOURCE = new DeferredBufferSource();
    }

    public static class DeferredBufferSource
    extends MultiBufferSource.BufferSource {
        protected final Supplier<ByteBufferBuilder> bufferSupplier;
        private final Collection<RenderType> delayed = new HashSet<RenderType>();

        protected DeferredBufferSource() {
            this(() -> new ByteBufferBuilder(786432), new LinkedHashMap<RenderType, ByteBufferBuilder>());
        }

        protected DeferredBufferSource(Supplier<ByteBufferBuilder> bufferSupplier, SequencedMap<RenderType, ByteBufferBuilder> fixedBuffers) {
            super(bufferSupplier.get(), fixedBuffers);
            this.bufferSupplier = bufferSupplier;
        }

        public void endBatches() {
            this.endBatch(ADDITIVE_TRANSLUCENT_BLOCK);
            this.endBatch(ADDITIVE_TRANSLUCENT_PARTICLE);
            for (RenderType type : this.delayed) {
                this.endBatch(type);
            }
        }

        @NotNull
        public VertexConsumer getBuffer(@NotNull RenderType renderType) {
            if (!this.fixedBuffers.containsKey(renderType)) {
                this.fixedBuffers.put(renderType, this.bufferSupplier.get());
                if (renderType != ADDITIVE_TRANSLUCENT_BLOCK && renderType != ADDITIVE_TRANSLUCENT_PARTICLE) {
                    this.delayed.add(renderType);
                }
            }
            return super.getBuffer(renderType);
        }

        public void endBatch(@NotNull RenderType renderType) {
            super.endBatch(renderType);
        }
    }
}

