/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockOffsets;
import net.mehvahdjukaar.polytone.block.BlockSetTypeProvider;
import net.mehvahdjukaar.polytone.block.IRenderProperties;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.particle.BlockParticleEmitter;
import net.mehvahdjukaar.polytone.sound.BlockSoundEmitter;
import net.mehvahdjukaar.polytone.sound.PolytoneSoundType;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockPropertyModifier(Optional<? extends BlockColor> tintGetter, Optional<SoundType> soundType, Optional<Function<BlockState, MapColor>> mapColor, Optional<Boolean> canOcclude, Optional<Boolean> spawnParticlesOnBreak, Optional<Boolean> breakingParticlesTinted, Optional<IRenderProperties> renderType, Optional<ToIntFunction<BlockState>> clientLight, List<BlockParticleEmitter> particleEmitters, List<BlockSoundEmitter> soundEmitters, Optional<BlockBehaviour.OffsetFunction> offsetType, Optional<BlockSetTypeProvider> blockSetType, Boolean disableParticles, @NotNull Targets targets, boolean tintHack) {
    public static final Decoder<BlockPropertyModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IndexCompoundColorGetter.SINGLE_OR_MULTIPLE.optionalFieldOf("colormap").forGetter(b -> b.tintGetter.flatMap(t -> {
        IndexCompoundColorGetter c;
        return Optional.ofNullable(t instanceof IndexCompoundColorGetter ? (c = (IndexCompoundColorGetter)t) : null);
    })), (App)PolytoneSoundType.CODEC.optionalFieldOf("sound_type").forGetter(BlockPropertyModifier::soundType), (App)MapColorHelper.CODEC.xmap(c -> a -> c, f -> MapColor.NONE).optionalFieldOf("map_color").forGetter(BlockPropertyModifier::mapColor), (App)Codec.BOOL.optionalFieldOf("can_occlude").forGetter(BlockPropertyModifier::canOcclude), (App)Codec.BOOL.optionalFieldOf("spawn_particles_on_break").forGetter(BlockPropertyModifier::spawnParticlesOnBreak), (App)Codec.BOOL.optionalFieldOf("tinted_breaking_particles").forGetter(BlockPropertyModifier::breakingParticlesTinted), (App)IRenderProperties.CODEC.optionalFieldOf("render_type").forGetter(BlockPropertyModifier::renderType), (App)Codec.intRange((int)0, (int)15).xmap(integer -> s -> integer, toIntFunction -> 0).optionalFieldOf("client_light").forGetter(BlockPropertyModifier::clientLight), (App)BlockParticleEmitter.CODEC.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(BlockPropertyModifier::particleEmitters), (App)BlockSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(BlockPropertyModifier::soundEmitters), (App)BlockOffsets.CODEC.optionalFieldOf("offset_type").forGetter(BlockPropertyModifier::offsetType), (App)BlockSetTypeProvider.CODEC.optionalFieldOf("block_set_type").forGetter(BlockPropertyModifier::blockSetType), (App)Codec.BOOL.optionalFieldOf("disable_particles", (Object)false).forGetter(BlockPropertyModifier::disableParticles), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(BlockPropertyModifier::targets), (App)Codec.BOOL.optionalFieldOf("force_tint_hack", (Object)false).forGetter(BlockPropertyModifier::tintHack)).apply((Applicative)instance, BlockPropertyModifier::new));
    public static final Decoder<BlockPropertyModifier> PARTIAL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IndexCompoundColorGetter.SINGLE_OR_MULTIPLE.optionalFieldOf("colormap").forGetter(b -> b.tintGetter.flatMap(t -> {
        IndexCompoundColorGetter c;
        return Optional.ofNullable(t instanceof IndexCompoundColorGetter ? (c = (IndexCompoundColorGetter)t) : null);
    }))).apply((Applicative)instance, c -> BlockPropertyModifier.ofBlockColor(c.orElse(null))));

    public BlockPropertyModifier merge(BlockPropertyModifier newMod) {
        return new BlockPropertyModifier(newMod.tintGetter.isPresent() ? newMod.tintGetter() : this.tintGetter(), newMod.soundType().isPresent() ? newMod.soundType() : this.soundType(), newMod.mapColor.isPresent() ? newMod.mapColor() : this.mapColor(), newMod.canOcclude().isPresent() ? newMod.canOcclude() : this.canOcclude(), newMod.spawnParticlesOnBreak().isPresent() ? newMod.spawnParticlesOnBreak() : this.spawnParticlesOnBreak(), newMod.breakingParticlesTinted().isPresent() ? newMod.breakingParticlesTinted() : this.breakingParticlesTinted(), newMod.renderType().isPresent() ? newMod.renderType() : this.renderType(), newMod.clientLight.isPresent() ? newMod.clientLight : this.clientLight, Utils.mergeList(newMod.particleEmitters, this.particleEmitters), Utils.mergeList(newMod.soundEmitters, this.soundEmitters), newMod.offsetType().isPresent() ? newMod.offsetType() : this.offsetType(), newMod.blockSetType().isPresent() ? newMod.blockSetType() : this.blockSetType(), newMod.disableParticles != false || this.disableParticles != false, newMod.targets.merge(this.targets), newMod.tintHack || this.tintHack);
    }

    public static BlockPropertyModifier ofBlockColor(BlockColor colormap) {
        return new BlockPropertyModifier(Optional.ofNullable(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, Targets.EMPTY, false);
    }

    public static BlockPropertyModifier coloringBlocks(BlockColor colormap, Block ... blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, Set.of((ResourceLocation[])Arrays.stream(blocks).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).toArray(ResourceLocation[]::new)));
    }

    public static BlockPropertyModifier coloringBlocks(BlockColor colormap, List<Block> blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, blocks.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).collect(Collectors.toSet()));
    }

    public static BlockPropertyModifier coloringBlocks(BlockColor colormap, Set<ResourceLocation> blocks) {
        Targets t = Targets.ofIds(blocks);
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), List.of(), Optional.empty(), Optional.empty(), false, t, false);
    }

    public BlockPropertyModifier apply(Block block) {
        SoundType oldSound = null;
        if (this.soundType.isPresent()) {
            oldSound = block.soundType;
            block.soundType = this.soundType.get();
        }
        Function oldMapColor = null;
        if (this.mapColor.isPresent()) {
            oldMapColor = block.properties.mapColor;
            block.properties.mapColor = this.mapColor.get();
            for (BlockState s : block.getStateDefinition().getPossibleStates()) {
                s.mapColor = (MapColor)block.properties.mapColor.apply(s);
            }
        }
        Boolean oldCanOcclude = null;
        if (this.canOcclude.isPresent()) {
            oldCanOcclude = block.properties.canOcclude;
            block.properties.canOcclude = this.canOcclude.get();
            for (UnmodifiableIterator s : block.getStateDefinition().getPossibleStates()) {
                s.canOcclude = this.canOcclude.get();
            }
        }
        Boolean oldSpawnParticlesOnBreak = null;
        if (this.spawnParticlesOnBreak.isPresent()) {
            oldSpawnParticlesOnBreak = block.properties.spawnTerrainParticles;
            block.properties.spawnTerrainParticles = this.spawnParticlesOnBreak.get();
            for (UnmodifiableIterator s : block.getStateDefinition().getPossibleStates()) {
                s.spawnTerrainParticles = block.properties.spawnTerrainParticles;
            }
        }
        ToIntFunction oldClientLight = null;
        if (this.clientLight.isPresent()) {
            oldClientLight = block.properties.lightEmission;
            block.properties.lightEmission = this.clientLight.get();
            for (BlockState s : block.getStateDefinition().getPossibleStates()) {
                s.lightEmission = block.properties.lightEmission.applyAsInt(s);
            }
        }
        BlockColor oldColor = null;
        if (this.tintGetter.isPresent()) {
            BlockColors blockColors = Minecraft.getInstance().getBlockColors();
            oldColor = PlatStuff.getBlockColor(blockColors, block);
            BlockColor blockColor = this.tintGetter.get();
            if (blockColor instanceof IColorGetter) {
                IColorGetter cg = (IColorGetter)blockColor;
                blockColor = Polytone.COLORMAPS.getOrCreateConcurrentColormap(cg);
            }
            blockColors.register(blockColor, new Block[]{block});
            Polytone.BLOCK_MODIFIERS.maybeAssignToDefaultGrassAndFoliage(block, blockColor);
        }
        BlockSetTypeProvider.Vanilla oldType = null;
        if (this.blockSetType.isPresent()) {
            if (block instanceof DoorBlock) {
                DoorBlock db = (DoorBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(db.type);
                db.type = this.blockSetType.get().getOrCreate(db.type(), this.soundType);
            } else if (block instanceof TrapDoorBlock) {
                TrapDoorBlock tb = (TrapDoorBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(tb.type);
                tb.type = this.blockSetType.get().getOrCreate(tb.type, this.soundType);
            } else if (block instanceof ButtonBlock) {
                ButtonBlock bb = (ButtonBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(bb.type);
                bb.type = this.blockSetType.get().getOrCreate(bb.type, this.soundType);
            } else if (block instanceof PressurePlateBlock) {
                PressurePlateBlock ppb = (PressurePlateBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(ppb.type);
                ppb.type = this.blockSetType.get().getOrCreate(ppb.type, this.soundType);
            }
        }
        if (this.tintHack) {
            Polytone.VARIANT_TEXTURES.addTintOverrideHack(block);
        }
        IRenderProperties oldRenderType = null;
        if (this.renderType.isPresent()) {
            oldRenderType = IRenderProperties.wrapVanilla(PlatStuff.getRenderType(block));
            IRenderProperties o = this.renderType.get();
            PlatStuff.setRenderType(block, o.toVanilla());
        }
        return new BlockPropertyModifier(Optional.ofNullable(oldColor), Optional.ofNullable(oldSound), Optional.ofNullable(oldMapColor), Optional.ofNullable(oldCanOcclude), Optional.ofNullable(oldSpawnParticlesOnBreak), Optional.empty(), Optional.ofNullable(oldRenderType), Optional.ofNullable(oldClientLight), List.of(), List.of(), Optional.empty(), Optional.ofNullable(oldType), false, Targets.EMPTY, false);
    }

    public boolean hasColormap() {
        return this.tintGetter.isPresent();
    }

    @Nullable
    public IColorGetter getColormap() {
        return this.tintGetter.orElse(null);
    }
}

