/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.StringRepresentable;

public interface IRenderProperties {
    public static final Codec<IRenderProperties> CODEC = Types.CODEC.flatXmap(DataResult::success, irp -> {
        if (irp instanceof Types) {
            Types t = (Types)irp;
            return DataResult.success((Object)t);
        }
        return DataResult.error(() -> "Tried to serialize non serializable render type: " + String.valueOf(irp.getClass()));
    });

    public Object toVanilla();

    public static IRenderProperties wrapVanilla(Object obj) {
        return () -> obj;
    }

    public static enum Types implements StringRepresentable,
    IRenderProperties
    {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRIPWIRE,
        TRANSLUCENT;

        private static final Codec<Types> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public Object toVanilla() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> RenderType.solid();
                case 2 -> RenderType.cutoutMipped();
                case 3 -> RenderType.tripwire();
                case 1 -> RenderType.cutout();
                case 4 -> RenderType.translucent();
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(Types::values);
        }
    }
}

