/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.DustParticleOptionAccessor;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.mehvahdjukaar.polytone.utils.Vec3f;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private final Object2IntMap<MapColor> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<DyeColor, Integer> vanillaFireworkColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaDiffuseColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaTextColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<ChatFormatting, Integer> vanillaChatFormatting = new EnumMap<ChatFormatting, Integer>(ChatFormatting.class);
    private final Object2IntMap<SpawnEggItem> vanillaEggsBackgrounds = new Object2IntOpenHashMap();
    private final Object2IntMap<SpawnEggItem> vanillaEggsHighlight = new Object2IntOpenHashMap();
    private final Object2IntMap<MobEffect> vanillaEffectColors = new Object2IntOpenHashMap();
    private final Map<MobEffect, Function<MobEffectInstance, ParticleOptions>> vanillaEffectParticles = new HashMap<MobEffect, Function<MobEffectInstance, ParticleOptions>>();
    private final EnumMap<BorderStatus, Integer> vanillaBorderStatus = new EnumMap(BorderStatus.class);
    private final Map<DyeColor, Integer> customSheepColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    protected final List<Vec3> originalRedstoneWireColors = Arrays.stream(RedStoneWireBlock.COLORS).toList();
    @Nullable
    ResourceLocation xpOrbParticle;
    @Nullable
    private BlockContextExpression xpOrbColor;
    @Nullable
    private BlockContextExpression xpOrbColorR;
    @Nullable
    private BlockContextExpression xpOrbColorG;
    @Nullable
    private BlockContextExpression xpOrbColorB;
    private Integer xpBar = null;
    private Integer splash = null;
    private Integer enchantTableXp = null;
    @Nullable
    private Integer fishingLineColor = null;
    @Nullable
    private Vec3f fishingLineOffset = null;

    public ColorManager() {
        super("colo_manager", "color.properties", "colors.json", new String[]{"polytone", "colormatic", "vanadium", "optifine"});
    }

    public Integer getXpBar() {
        return this.xpBar;
    }

    public Integer getSplash() {
        return this.splash;
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, RegistryAccess access) {
        ArrayList<ResourceLocation> keySet = new ArrayList<ResourceLocation>(jsons.keySet());
        Lists.reverse(keySet);
        for (ResourceLocation k : keySet) {
            JsonElement root = jsons.get(k);
            try {
                this.parseColorJson(root, k);
            }
            catch (Exception e1) {
                Polytone.LOGGER.error("Failed to parse color JSON in file {}", (Object)k, (Object)e1);
            }
        }
        this.regenSheepColors();
    }

    private void parseColorJson(JsonElement root, ResourceLocation fileId) {
        JsonObject obj = root.getAsJsonObject();
        ColorManager.doWith(obj, "map", (k, v) -> {
            MapColor color = MapColorHelper.byName(k);
            if (color != null) {
                int col = ColorManager.parseHex(v);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.col);
                }
                color.col = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", k);
            }
        });
        ColorManager.doWith(obj, "dye", (k, v) -> {
            DyeColor color = DyeColor.byName((String)k, null);
            if (color == null) {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", k);
                return;
            }
            for (Map.Entry<String, JsonElement> entry : ColorManager.entries(v)) {
                String param = entry.getKey();
                int col = ColorManager.parseHex(entry.getValue());
                switch (param) {
                    case "diffuse": {
                        if (!this.vanillaDiffuseColors.containsKey(color)) {
                            this.vanillaDiffuseColors.put(color, color.getTextureDiffuseColor());
                        }
                        color.textureDiffuseColor = FastColor.ARGB32.opaque((int)col);
                        break;
                    }
                    case "firework": {
                        if (!this.vanillaFireworkColors.containsKey(color)) {
                            this.vanillaFireworkColors.put(color, color.fireworkColor);
                        }
                        color.fireworkColor = col;
                        break;
                    }
                    case "text": {
                        if (!this.vanillaTextColors.containsKey(color)) {
                            this.vanillaTextColors.put(color, color.textColor);
                        }
                        color.textColor = col;
                    }
                }
            }
        });
        ColorManager.doWith(obj, "particle", (k, v) -> {
            ResourceLocation id = ResourceLocation.parse((String)k.replace("\\", ""));
            try {
                int hex = ColorManager.parseHex(v);
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
            }
            catch (Exception e) {
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, v.getAsString());
            }
        });
        ColorManager.doWith(obj, "fishing_line", (k, v) -> {
            switch (k) {
                case "color": {
                    this.fishingLineColor = ColorManager.parseHex(v);
                    break;
                }
                case "offset": {
                    this.fishingLineOffset = (Vec3f)((Pair)Vec3f.CODEC.decode((DynamicOps)JsonOps.INSTANCE, v).getOrThrow()).getFirst();
                }
            }
        });
        ColorManager.doWith(obj, "world_border", (k, v) -> {
            BorderStatus status = BorderStatus.valueOf((String)k.toLowerCase(Locale.ROOT));
            int col = ColorManager.parseHex(v);
            if (!this.vanillaBorderStatus.containsKey(status)) {
                this.vanillaBorderStatus.put(status, status.getColor());
            }
            status.color = col;
        });
        ColorManager.doWith(obj, "effect", (k, v) -> {
            ResourceLocation id = ResourceLocation.parse((String)k.replace("\\", ""));
            ParticleOptions particle = (ParticleOptions)ColorManager.get(v, "particle", ParticleTypes.CODEC);
            String color = ColorManager.getString(v, "color");
            Integer col = color == null && v instanceof JsonPrimitive ? Integer.valueOf(ColorManager.parseHex(v)) : Integer.valueOf(ColorManager.parseHex(color));
            if (!id.getPath().equals("empty")) {
                if (id.getPath().equals("water")) {
                    PotionContents.BASE_POTION_COLOR = col;
                } else {
                    MobEffect effect = BuiltInRegistries.MOB_EFFECT.getOptional(id).orElse(null);
                    if (effect != null) {
                        if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                            this.vanillaEffectColors.put((Object)effect, effect.getColor());
                        }
                        effect.color = col;
                        if (particle != null) {
                            if (!this.vanillaEffectParticles.containsKey(effect)) {
                                this.vanillaEffectParticles.put(effect, effect.particleFactory);
                            }
                            effect.particleFactory = mobEffectInstance -> particle;
                        }
                    } else {
                        Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                    }
                }
            }
        });
        ColorManager.doWith(obj, "egg", (k, v) -> {
            EntityType entity;
            ResourceLocation id = ResourceLocation.parse((String)k.replace("\\", ""));
            Item item = BuiltInRegistries.ITEM.getOptional(id).orElse(null);
            if (item == null && (entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(id).orElse(null)) != null) {
                item = SpawnEggItem.byId((EntityType)entity);
            }
            if (item == null) {
                item = BuiltInRegistries.ITEM.getOptional(id.withSuffix("_spawn_egg")).orElse(null);
            }
            if (item instanceof SpawnEggItem) {
                String spots;
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                String shell = ColorManager.getString(v, "shell");
                if (shell != null) {
                    if (!this.vanillaEggsBackgrounds.containsKey((Object)spawnEggItem)) {
                        this.vanillaEggsBackgrounds.put((Object)spawnEggItem, spawnEggItem.backgroundColor);
                    }
                    spawnEggItem.backgroundColor = ColorManager.parseHex(shell);
                }
                if ((spots = ColorManager.getString(v, "spots")) != null) {
                    if (!this.vanillaEggsHighlight.containsKey((Object)spawnEggItem)) {
                        this.vanillaEggsHighlight.put((Object)spawnEggItem, spawnEggItem.highlightColor);
                    }
                    spawnEggItem.highlightColor = ColorManager.parseHex(spots);
                }
            } else {
                Polytone.LOGGER.warn("Unknown or invalid Spawn Egg Item with name {}", (Object)id);
            }
        });
        ColorManager.doWith(obj, "sheep", (k, v) -> {
            DyeColor color = DyeColor.byName((String)k, null);
            if (color != null) {
                int col = FastColor.ARGB32.opaque((int)ColorManager.parseHex(v));
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", k);
            }
        });
        ColorManager.doWith(obj, "xporb", (k, v) -> {
            switch (k) {
                case "particle_replacement": {
                    Polytone.PARTICLE_MODIFIERS.setXpOrbReplace((JsonElement)v);
                    break;
                }
                case "color": {
                    this.xpOrbColor = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "red": {
                    this.xpOrbColorR = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "green": {
                    this.xpOrbColorG = new BlockContextExpression(v.getAsString());
                    break;
                }
                case "blue": {
                    this.xpOrbColorB = new BlockContextExpression(v.getAsString());
                }
            }
        });
        ColorManager.doWith(obj, "redstone", (k, v) -> {
            int code = Integer.parseInt(k);
            if (code < RedStoneWireBlock.COLORS.length) {
                int col = ColorManager.parseHex(v);
                float[] rgb = ColorUtils.unpack(col);
                RedStoneWireBlock.COLORS[code] = new Vec3((double)rgb[0], (double)rgb[1], (double)rgb[2]);
                if (code == 15) {
                    Vector3f maxPower;
                    DustParticleOptions.REDSTONE_PARTICLE_COLOR = maxPower = new Vector3f(rgb[0], rgb[1], rgb[2]);
                    ((DustParticleOptionAccessor)DustParticleOptions.REDSTONE).setColor(maxPower);
                }
            } else {
                Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
            }
        });
        ColorManager.doWith(obj, "text", (k, v) -> {
            if (k.equals("splash")) {
                this.splash = ColorManager.parseHex(v);
            } else if (k.equals("xpbar")) {
                this.xpBar = ColorManager.parseHex(v);
            } else if (k.startsWith("code:")) {
                String s = k.substring(5);
                int code = Integer.parseInt(s);
                ChatFormatting text = ChatFormatting.getById((int)code);
                this.setTextColor(text, ColorManager.parseHex(v));
            } else if (k.equals("code")) {
                for (Map.Entry<String, JsonElement> entry : ColorManager.entries(v)) {
                    String s = entry.getKey();
                    int code = Integer.parseInt(s);
                    ChatFormatting text = ChatFormatting.getById((int)code);
                    this.setTextColor(text, ColorManager.parseHex(entry.getValue()));
                }
            } else {
                ChatFormatting text = ChatFormatting.getByName((String)k);
                this.setTextColor(text, ColorManager.parseHex(v));
            }
        });
        ColorManager.doWith(obj, "palette", (k, v) -> {
            if (k.equals("block") && v.isJsonObject()) {
                for (Map.Entry<String, JsonElement> entry : ColorManager.getEntries(v.getAsJsonObject(), "block")) {
                    String path = entry.getKey().replace("~/colormap/", fileId.getNamespace() + ":");
                    Polytone.BLOCK_MODIFIERS.addSimpleColormap(ResourceLocation.parse((String)path), entry.getValue().getAsString());
                }
            }
        });
    }

    private void setTextColor(ChatFormatting text, int col) {
        if (!this.vanillaChatFormatting.containsKey(text)) {
            this.vanillaChatFormatting.put(text, text.getColor());
        }
        text.color = col;
        TextColor tc = TextColor.fromLegacyFormat((ChatFormatting)text);
        tc.value = col;
    }

    private static void doWith(JsonObject obj, String key, BiConsumer<String, JsonElement> entryHandler) {
        try {
            if (obj.has(key)) {
                JsonObject sub = GsonHelper.getAsJsonObject((JsonObject)obj, (String)key);
                for (Map.Entry entry : sub.entrySet()) {
                    entryHandler.accept((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }
        catch (JsonParseException e) {
            throw new JsonParseException("Failed to parse color JSON for key: " + key, (Throwable)e);
        }
    }

    private static Set<Map.Entry<String, JsonElement>> getEntries(JsonObject element, String key) {
        JsonElement elements = element.get(key);
        if (elements != null && elements.isJsonObject()) {
            return elements.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static <T> T get(JsonElement element, String key, Codec<T> codec) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null) {
            return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)joo).getOrThrow()).getFirst();
        }
        return null;
    }

    @Nullable
    private static String getString(JsonElement element, String key) {
        JsonObject jo;
        JsonElement joo;
        if (element instanceof JsonObject && (joo = (jo = (JsonObject)element).get(key)) != null && joo.isJsonPrimitive() && joo.getAsJsonPrimitive().isString()) {
            return joo.getAsString();
        }
        return null;
    }

    private static Set<Map.Entry<String, JsonElement>> entries(JsonElement element) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject().entrySet();
        }
        return Collections.emptySet();
    }

    private static int parseHex(JsonElement obj) {
        return (Integer)((Pair)ColorUtils.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow()).getFirst();
    }

    private static int parseHex(String str) {
        str = str.replace("#", "").replace("0x", "");
        return Integer.parseInt(str.trim(), 16);
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        SpawnEggItem item;
        MobEffect effect;
        MapColor color;
        PotionContents.BASE_POTION_COLOR = 3694022;
        this.xpBar = null;
        this.xpOrbParticle = null;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        this.fishingLineOffset = null;
        this.fishingLineColor = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (MapColor)entry.getKey();
            color.col = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.textureDiffuseColor = (Integer)entry.getValue();
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.fireworkColor = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.textColor = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaChatFormatting.entrySet()) {
            ChatFormatting text = (ChatFormatting)entry.getKey();
            text.color = (Integer)entry.getValue();
            TextColor tc = TextColor.fromLegacyFormat((ChatFormatting)text);
            tc.value = (Integer)entry.getValue();
        }
        this.vanillaChatFormatting.clear();
        for (Object2IntMap.Entry entry : this.vanillaEffectColors.object2IntEntrySet()) {
            effect = (MobEffect)entry.getKey();
            effect.color = entry.getIntValue();
        }
        this.vanillaEffectColors.clear();
        for (Map.Entry entry : this.vanillaEffectParticles.entrySet()) {
            effect = (MobEffect)entry.getKey();
            effect.particleFactory = (Function)entry.getValue();
        }
        this.vanillaEffectParticles.clear();
        for (Map.Entry entry : this.vanillaBorderStatus.entrySet()) {
            BorderStatus status = (BorderStatus)entry.getKey();
            status.color = (Integer)entry.getValue();
        }
        this.vanillaBorderStatus.clear();
        for (Map.Entry entry : this.vanillaEggsBackgrounds.entrySet()) {
            item = (SpawnEggItem)entry.getKey();
            item.backgroundColor = (Integer)entry.getValue();
        }
        this.vanillaEggsBackgrounds.clear();
        for (Map.Entry entry : this.vanillaEggsHighlight.entrySet()) {
            item = (SpawnEggItem)entry.getKey();
            item.highlightColor = (Integer)entry.getValue();
        }
        this.vanillaEggsHighlight.clear();
        RedStoneWireBlock.COLORS = this.originalRedstoneWireColors.toArray(new Vec3[0]);
        DustParticleOptions.REDSTONE_PARTICLE_COLOR = new Vector3f(1.0f, 0.0f, 0.0f);
        ((DustParticleOptionAccessor)DustParticleOptions.REDSTONE).setColor(DustParticleOptions.REDSTONE_PARTICLE_COLOR);
    }

    public void regenSheepColors() {
        Sheep.COLOR_BY_DYE = new EnumMap(DyeColor.class);
        for (DyeColor d : DyeColor.values()) {
            Sheep.COLOR_BY_DYE.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        Sheep.COLOR_BY_DYE.putAll(this.customSheepColors);
        this.customSheepColors.clear();
    }

    public float @Nullable [] getXpOrbColor(ExperienceOrb orb, float partialTicks) {
        Level level = orb.level();
        float time = (float)orb.tickCount + partialTicks;
        Vec3 position = orb.position();
        if (this.xpOrbColor != null) {
            int color = (int)this.xpOrbColor.getValue(position, time, level);
            return ColorUtils.unpack(color);
        }
        if (this.xpOrbColorR == null && this.xpOrbColorG == null && this.xpOrbColorB == null) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (this.xpOrbColorR != null) {
            r = (float)this.xpOrbColorR.getValue(position, time, level);
        }
        if (this.xpOrbColorG != null) {
            g = (float)this.xpOrbColorG.getValue(position, time, level);
        }
        if (this.xpOrbColorB != null) {
            b = (float)this.xpOrbColorB.getValue(position, time, level);
        }
        return new float[]{r, g, b};
    }

    @Nullable
    public Vec3f getFishingLineOffset() {
        return this.fishingLineOffset;
    }

    @Nullable
    public Integer getFishingLineColor() {
        return this.fishingLineColor;
    }
}

