/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleModifiersManager
extends JsonImgPartialReloader {
    private final Multimap<ParticleType<?>, ParticleModifier> particleModifiers = HashMultimap.create();
    @Nullable
    private JsonElement xpOrbReplaceJson = null;
    @Nullable
    private ParticleOptions xpOrbReplaceParticle = null;

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(ParticleOptions options, Level level, @NotNull Particle particle) {
        Collection mod = this.particleModifiers.get((Object)options.getType());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, RegistryAccess access) {
        Parsed v;
        ResourceLocation id;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        Parsed.SortedMap<ParticleModifier> parsedModifiers = Parsed.batchParseOrPartial(jsons, ParticleModifier.CODEC, ParticleModifier.PARTIAL_CODEC, ops, "particle modifier");
        for (Map.Entry<ResourceLocation, Parsed<ParticleModifier>> entry : parsedModifiers.entrySet()) {
            id = entry.getKey();
            Parsed<ParticleModifier> parsed = entry.getValue();
            ParticleModifier modifier = parsed.getResultOrPartial();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                modifier.setColormap(Colormap.createDefTriangle());
            }
            BlockColor tint = modifier.getColormap();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ParticleModifier.ofColormap(defaultColormap));
        }
        if (this.xpOrbReplaceJson != null && (v = Parsed.parseAlways(ParticleTypes.CODEC, this.xpOrbReplaceJson, ops, ResourceLocation.withDefaultNamespace((String)"xp_orb"), "XP orb modifier")).isEnabled()) {
            this.xpOrbReplaceParticle = (ParticleOptions)v.getResultOrPartial();
        }
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
        if (!this.particleModifiers.isEmpty()) {
            Polytone.LOGGER.info("Registered {} particle modifiers", (Object)this.particleModifiers.size());
        }
    }

    private void addModifier(ResourceLocation pathId, ParticleModifier mod) {
        for (Holder p : mod.targets().compute(pathId, BuiltInRegistries.PARTICLE_TYPE.asLookup())) {
            this.particleModifiers.put((Object)((ParticleType)p.value()), (Object)mod);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(ResourceLocation id, String color) {
        Optional opt = BuiltInRegistries.PARTICLE_TYPE.getOptional(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }

    public void setXpOrbReplace(JsonElement json) {
        this.xpOrbReplaceJson = json;
    }

    @Nullable
    public ParticleOptions getXpOrbReplaceParticle() {
        return this.xpOrbReplaceParticle;
    }
}

