/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public record SimpleSprite(ResourceLocation texture, float x, float y, float width, float height, float z, Optional<String> tooltip) implements Renderable
{
    public static final Codec<SimpleSprite> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SimpleSprite::texture), (App)Codec.FLOAT.fieldOf("x").forGetter(SimpleSprite::x), (App)Codec.FLOAT.fieldOf("y").forGetter(SimpleSprite::y), (App)Codec.FLOAT.fieldOf("width").forGetter(SimpleSprite::width), (App)Codec.FLOAT.fieldOf("height").forGetter(SimpleSprite::height), (App)Codec.FLOAT.optionalFieldOf("z", (Object)Float.valueOf(0.0f)).forGetter(SimpleSprite::z), (App)Codec.STRING.optionalFieldOf("tooltip").forGetter(SimpleSprite::tooltip)).apply((Applicative)i, SimpleSprite::new));

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(this.texture);
        SimpleSprite.blit(guiGraphics.pose().last().pose(), sprite.atlasLocation(), this.x, this.x + this.width, this.y, this.y + this.height, this.z, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
    }

    public static void blit(Matrix4f matrix, ResourceLocation atlasLoc, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLoc);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, x1, y1, blitOffset).setUv(minU, minV);
        bufferBuilder.addVertex(matrix, x1, y2, blitOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix, x2, y2, blitOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix, x2, y1, blitOffset).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

