/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.slotify.IntRange;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public record WidgetModifier(int xOffset, int yOffset, int width, Optional<String> message, Optional<IntRange> targetX, Optional<IntRange> targetY, Optional<IntRange> targetW, Optional<IntRange> targetH, Optional<String> targetMessage, Optional<String> targetClass) {
    public static final Codec<WidgetModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(WidgetModifier::xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(WidgetModifier::yOffset), (App)Codec.INT.optionalFieldOf("width_increment", (Object)0).forGetter(WidgetModifier::width), (App)Codec.STRING.optionalFieldOf("message").forGetter(WidgetModifier::message), (App)IntRange.CODEC.optionalFieldOf("target_x").forGetter(WidgetModifier::targetX), (App)IntRange.CODEC.optionalFieldOf("target_y").forGetter(WidgetModifier::targetY), (App)IntRange.CODEC.optionalFieldOf("target_width").forGetter(WidgetModifier::targetY), (App)IntRange.CODEC.optionalFieldOf("target_height").forGetter(WidgetModifier::targetY), (App)Codec.STRING.optionalFieldOf("target_message").forGetter(WidgetModifier::targetMessage), (App)Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName).optionalFieldOf("target_class_name").forGetter(WidgetModifier::targetClass)).apply((Applicative)i, WidgetModifier::new)).comapFlatMap(o -> {
        if (o.targetW.isEmpty() && o.targetH.isEmpty() && o.targetX.isEmpty() && o.targetClass.isEmpty() && o.targetY.isEmpty() && o.targetMessage.isEmpty()) {
            return DataResult.error(() -> "Widget modifier must have at least one target");
        }
        return DataResult.success((Object)o);
    }, Function.identity());

    public void maybeModify(AbstractWidget widget) {
        if (this.targetX.isPresent() && !this.targetX.get().has(widget.getX())) {
            return;
        }
        if (this.targetY.isPresent() && !this.targetY.get().has(widget.getY())) {
            return;
        }
        if (this.targetH.isPresent() && !this.targetH.get().has(widget.getHeight())) {
            return;
        }
        if (this.targetW.isPresent() && !this.targetW.get().has(widget.getWidth())) {
            return;
        }
        if (this.targetMessage.isPresent() && !widget.getMessage().getString().equals(this.targetMessage.get())) {
            return;
        }
        if (this.targetClass.isPresent()) {
            String name = this.targetClass.get();
            if (!widget.getClass().getSimpleName().equals(name) && !widget.getClass().getName().equals(name)) {
                return;
            }
        }
        widget.setX(widget.getX() + this.xOffset);
        widget.setY(widget.getY() + this.yOffset);
        widget.setWidth(widget.getWidth() + this.width);
        this.message.ifPresent(s -> widget.setMessage((Component)Component.translatable((String)s)));
    }
}

