/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public abstract class SingleJsonOrPropertiesReloadListener
extends PartialReloader<Map<ResourceLocation, JsonElement>> {
    private static final Gson GSON = new Gson();
    private final String[] folders;
    private final String propertiesName;
    private final String jsonName;

    protected SingleJsonOrPropertiesReloadListener(String myName, String propertiesName, String jsonName, String ... possibleFolderLocations) {
        super(myName);
        this.folders = possibleFolderLocations;
        this.propertiesName = propertiesName;
        this.jsonName = jsonName;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager) {
        HashMap<ResourceLocation, Object> jsonObjects = new HashMap<ResourceLocation, Object>();
        for (String path : this.folders) {
            Map propertiesResources = resourceManager.listResourceStacks(path, id -> id.getPath().endsWith(this.propertiesName));
            for (Map.Entry entry : propertiesResources.entrySet()) {
                List resourceStack = (List)entry.getValue();
                for (Resource resource : resourceStack) {
                    try {
                        BufferedReader reader = resource.openAsReader();
                        try {
                            Properties properties = new Properties();
                            properties.load(reader);
                            JsonObject json = PropertiesUtils.propertiesToJson(properties);
                            jsonObjects.put((ResourceLocation)entry.getKey(), json);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse .properties file {}:", (Object)resource, (Object)ex);
                    }
                }
            }
            Map resources = resourceManager.listResourceStacks(path, id -> id.getPath().endsWith(this.jsonName));
            for (Map.Entry entrySet : resources.entrySet()) {
                List resourceStack = (List)entrySet.getValue();
                ResourceLocation id2 = (ResourceLocation)entrySet.getKey();
                for (Resource resource : resourceStack) {
                    try {
                        BufferedReader reader = resource.openAsReader();
                        try {
                            JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                            if (jsonObjects.containsKey(id2)) {
                                Polytone.LOGGER.warn("Found duplicate color.json with path {}. Old one will be overwritten. Be sure to put this file in your own namespace, not minecraft one!", (Object)id2);
                            }
                            jsonObjects.put(id2, jsonElement);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse data file {}:", (Object)resource, (Object)ex);
                    }
                }
            }
        }
        return ImmutableMap.copyOf(jsonObjects);
    }
}

